#' @title Sample Raman spectrum
#'
#' @description
#' Raman spectrum of high-density polyethylene (HDPE).
#'
#' @format
#' A data table containing 964 rows and 2 columns:
#' \tabular{ll}{
#' \code{wavenumber}: \tab spectral wavenumber [1/cm] \cr
#' \code{intensity}: \tab absorbance values [-] \cr
#' }
#'
#' @examples
#' data("raman_hdpe")
#'
#' @author
#' Win Cowger
#'
#' @references
#' Cowger W, Gray A, Christiansen SH, Christiansen SH, Christiansen SH,
#' De Frond H, Deshpande AD, Hemabessiere L, Lee E, Mill L, et al. (2020).
#' “Critical Review of Processing and Classification Techniques for Images and
#' Spectra in Microplastic Research.” \emph{Applied Spectroscopy},
#' \strong{74}(9), 989–1010. \doi{10.1177/0003702820929064}.
#'
#' @docType data
#' @keywords data
#' @name raman_hdpe
NULL
