% Generated by roxygen2 (4.0.2): do not edit by hand
\name{importExcel}
\alias{importExcel}
\title{Import grid data from an Excel file.}
\usage{
importExcel(file, dir = NULL, sheetIndex = 1, min = NULL, max = NULL)
}
\arguments{
\item{file}{A vector of filenames including the full path if file is not in current working
directory. The file suffix has to be \code{.xlsx} or \code{.xls}.
If no file is supplied a selection pop up menu is opened to select
the files.}

\item{dir}{Alternative way to supply the directory where the file is located
(default \code{NULL}).}

\item{sheetIndex}{The number of the Excel sheet that contains the grid data.}

\item{min}{Optional argument (\code{numeric}, default \code{NULL})
for minimum rating value in grid.}

\item{max}{Optional argument (\code{numeric}, default \code{NULL})
for maximum rating value in grid.}
}
\value{
A single \code{repgrid} object in case one file and
               a list of \code{repgrid} objects in case multiple files are imported.
}
\description{
If you do not have a grid program at hand you can define a grid using
Microsoft Excel and by saving it as a \code{.xlsx} or \code{.xls} file.
The \code{.xlsx} or \code{.xls} file has to be in specified fixed
format. The first row contains the minimum of the rating scale, the names of
the elements and the maximum of the rating scale. Below every row contains
the left construct pole, the ratings and the right construct pole.
}
\details{
\tabular{lllll}{
\code{1} & \code{element 1} & \code{element 2} & \code{element 3} & \code{5} \cr
\code{1} & \code{element 1} & \code{element 2} & \code{element 3} & \code{5} \cr
\code{1} & \code{element 1} & \code{element 2} & \code{element 3} & \code{5} \cr
}

Note that the maximum and minimum value has to be defined using the
\code{min} and \code{max} arguments if no values are supplied at the
beginning and end of the first row. Otherwise the scaling range is inferred
from the available data and a warning is issued as the range may be
erroneous. This may effect other functions that depend on knowing the correct
range and it is thus strongly recommended to set the scale range correctly.

A sample Excel file can be found here:
\url{http://www.openrepgrid.uni-bremen.de/data/grid.xlsx}.
}
\examples{
\dontrun{

# using the pop-up selection menu
rg <- importExcel()

# supposing that the data file sample.txt is in the current directory
file <- "grid.xlsx"
rg <- importExcel(file)

# specifying a directory (arbitrary example directory)
dir <- "/Users/markheckmann/data"
rg <- importExcel(file, dir)

# using a full path
rg <- importExcel("/Users/markheckmann/data/grid.xlsx")

# import more than one Excel file via R code
files <- c("grid_1.xlsx", "grid_2.xlsx")
rg <- importExcel(files)
}
}
\author{
Mark Heckmann
}
\seealso{
\code{\link{importGridcor}},
               \code{\link{importGridstat}},
               \code{\link{importScivesco}},
               \code{\link{importGridsuite}},
               \code{\link{importTxt}}
}

