% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MxUnitTesting.R
\name{omxCheckError}
\alias{omxCheckError}
\title{Correct Error Message Function}
\usage{
omxCheckError(expression, message)
}
\arguments{
\item{expression}{an R expression that produces an error}

\item{message}{a character string with the desired error message}
}
\description{
This function tests whether the correct error message is thrown.
}
\details{
Arguments \sQuote{expression} and \sQuote{message} give the expression
that generates the error and the message that is supposed to be generated, respectively.
}
\examples{
A <- mxMatrix('Full', 1, 1, labels = 'data.foo', free = TRUE, name = 'A')
model <- mxModel('model', A)
omxCheckError(mxRun(model),
	paste("The definition variable 'data.foo'",
		"has been assigned to a",
		"free parameter in matrix 'A'"))
omxCheckCloseEnough(matrix(3, 3, 3), matrix(4, 3, 3), epsilon = 2)
# Throws error, check the message
tmsg <- paste("In omxCheckCloseEnough(c(1, 2, 3), c(1.1, 1.9, 3), 0.01)",
		": not equal to within 0.01 : '1 2 3' and '1.1 1.9 3'")
omxCheckError(omxCheckCloseEnough(c(1, 2, 3), c(1.1, 1.9 ,3.0), .01), tmsg)
}
\references{
The OpenMx User's guide can be found at http://openmx.psyc.virginia.edu/documentation.
}
\seealso{
\code{\link{omxCheckWarning}}
\code{\link{omxCheckWithinPercentError}},
\code{\link{omxCheckIdentical}}, \code{\link{omxCheckSetEquals}},
\code{\link{omxCheckTrue}}, \code{\link{omxCheckEquals}}
}

