% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MxUnitTesting.R
\name{omxCheckCloseEnough}
\alias{omxCheckCloseEnough}
\title{Approximate Equality Testing Function}
\usage{
omxCheckCloseEnough(a, b, epsilon = 10^(-15), na.action = na.fail)
}
\arguments{
\item{a}{a numeric vector or matrix}

\item{b}{a numeric vector or matrix}

\item{epsilon}{a non-negative tolerance threshold}

\item{na.action}{either na.fail (default) or na.pass. Use of
na.omit or na.exclude is not recommended.}
}
\description{
This function tests whether two numeric vectors or matrixes are
approximately equal to one another, within a specified threshold.
}
\details{
Arguments \sQuote{a} and \sQuote{b} must be of the same type,
ie. they must be either vectors of equal dimension or matrices of
equal dimension. The two arguments are compared element-wise for
approximate equality.  If the absolute value of the difference of
any two values is greater than the threshold, then an error will
be thrown. If \sQuote{a} and \sQuote{b} are approximately equal to
each other, by default the function will print a statement
informing the user the test has passed.  To turn off these print
statements use \code{options("mxPrintUnitTests" = FALSE)}.

When na.action is set to na.pass, a and b are expected to have
identical missingness patterns.
}
\examples{
omxCheckCloseEnough(c(1, 2, 3), c(1.1, 1.9 ,3.0), epsilon = 0.5)
omxCheckCloseEnough(matrix(3, 3, 3), matrix(4, 3, 3), epsilon = 2)
# Throws an error
try(omxCheckCloseEnough(c(1, 2, 3), c(1.1, 1.9 ,3.0), epsilon = 0.01))
}
\references{
The OpenMx User's guide can be found at http://openmx.psyc.virginia.edu/documentation.
}
\seealso{
\code{\link{omxCheckWithinPercentError}},
\code{\link{omxCheckIdentical}}, \code{\link{omxCheckSetEquals}},
\code{\link{omxCheckTrue}}, \code{\link{omxCheckEquals}}
}

