% Generated by roxygen2 (4.0.2): do not edit by hand
\name{mxComputeGradientDescent}
\alias{MxComputeGradientDescent-class}
\alias{mxComputeGradientDescent}
\title{Optimize parameters using a gradient descent optimizer}
\usage{
mxComputeGradientDescent(freeSet = NA_character_, ..., engine = NULL,
  fitfunction = "fitfunction", verbose = 0L, tolerance = NA_real_,
  useGradient = NULL, warmStart = NULL, nudgeZeroStarts = TRUE,
  maxMajorIter = NULL, gradientAlgo = mxOption(NULL, "Gradient algorithm"),
  gradientIterations = 2, gradientStepSize = 1e-05)
}
\arguments{
\item{freeSet}{names of matrices containing free variables}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{engine}{specific NPSOL or SLSQP}

\item{fitfunction}{name of the fitfunction (defaults to 'fitfunction')}

\item{verbose}{level of debugging output}

\item{tolerance}{how close to the optimum is close enough (also known as the optimality tolerance)}

\item{useGradient}{whether to use the analytic gradient (if available)}

\item{warmStart}{a Cholesky factored Hessian to use as the NPSOL Hessian starting value (preconditioner)}

\item{nudgeZeroStarts}{whether to nudge any zero starting values prior to optimization (default TRUE)}

\item{maxMajorIter}{maximum number of major iterations}

\item{gradientAlgo}{one of c('forward','central')}

\item{gradientIterations}{number of Richardson iterations to use for the gradient (default 2)}

\item{gradientStepSize}{the step size for the gradient (default 1e-5)}
}
\description{
This optimizer does not require analytic derivatives of the fit
function. The open-source version of OpenMx only offers 1 choice,
SLSQP (from the NLOPT collection).  The proprietary version of
OpenMx offers the choice of two optimizers, SLSQP and NPSOL.
}
\details{
One of the most important options for SLSQP is
\code{gradientAlgo}. By default, the \code{forward} method is
used. This method requires \code{gradientIterations} function
evaluations per parameter per gradient.  This method often works
well enough but can result in imprecise gradient estimations that
may not allow SLSQP to fully optimize a given model. If code red
is reported then you are encouraged to try the \code{central}
method. The \code{central} method requires 2 times
\code{gradientIterations} function evaluations per parameter per
gradient, but it can be much more accurate.
}
\examples{
data(demoOneFactor)
factorModel <- mxModel(name ="One Factor",
  mxMatrix(type="Full", nrow=5, ncol=1, free=FALSE, values=0.2, name="A"),
    mxMatrix(type="Symm", nrow=1, ncol=1, free=FALSE, values=1, name="L"),
    mxMatrix(type="Diag", nrow=5, ncol=5, free=TRUE, values=1, name="U"),
    mxAlgebra(expression=A \%*\% L \%*\% t(A) + U, name="R"),
  mxExpectationNormal(covariance="R", dimnames=names(demoOneFactor)),
  mxFitFunctionML(),
    mxData(observed=cov(demoOneFactor), type="cov", numObs=500),
     mxComputeSequence(steps=list(
     mxComputeGradientDescent(),
     mxComputeNumericDeriv(),
     mxComputeStandardError(),
     mxComputeHessianQuality()
    )))
factorModelFit <- mxRun(factorModel)
factorModelFit$output$conditionNumber # 29.5
}
\references{
Luenberger, D. G. & Ye, Y. (2008). \emph{Linear and nonlinear programming.} Springer.
}

