% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{package}
\name{OpenMx}
\alias{OpenMx}
\alias{OpenMx-package}
\title{OpenMx: An package for Structural Equation Modeling and Matrix Algebra Optimization}
\description{
OpenMx is a package for structural equation modeling, matrix algebra optimization and other statistical estimation problems. 
Try the example below. We try and have useful help files: for instance help(\code{\link{mxRun}}) to learn more. Also the reference manual
}
\details{
OpenMx solves algebra optimization and statistical estimation problems using matrix algebra. 
Most users use it for Structural equation modeling.

The core function is \code{\link{mxModel}}, which makes a model. Models are containers for \code{\link{mxData}}, \code{\link[=mxMatrix]{matrices}}, \code{\link{mxPath}}s
\code{\link[=mxAlgebra]{algebras}}, \link{mxBounds}, \code{\link[=mxCI]{confidence intervals}}, and \code{\link[=mxConstraint]{mxConstraints}}.
Most models require an expectation (see the list below) to calculate the expectations for the model.
Models also need a fit function, several of which are built-in (see below).
OpenMx also allows user-defined fit functions for purposes not covered by the built-in functions. (e.g., \code{\link{mxFitFunctionR}} or \code{\link{mxFitFunctionAlgebra}}).

\emph{Note}, for mxModels of \code{type="RAM"}, the expectation and fit-function are set for you automatically.

\strong{Running and summarizing a model}

Once built, the resulting mxModel can be run (i.e., optimized) using  \code{\link{mxRun}}. This returns the fitted model.

You can summarize the results of the model using \code{\link[=summary.MxModel]{summary}}(yourModel)

\strong{Additional overview of model making and getting started}

The OpenMx manual is online (see references below). However, \code{\link{mxRun}}, \code{\link{mxModel}}, \code{\link{mxMatrix}}
all have working examples that will help get you started as well.

The main OpenMx functions are: \code{\link{mxAlgebra}}, \code{\link{mxBounds}}, \code{\link{mxCI}}, \code{\link{mxConstraint}}, \code{\link{mxData}}, 
\code{\link{mxMatrix}}, \code{\link{mxModel}}, and \code{\link{mxPath}}.

Expectation functions include \code{\link{mxExpectationNormal}}, \code{\link{mxExpectationRAM}}, \code{\link{mxExpectationLISREL}}, and \code{\link{mxExpectationStateSpace}};

Fit functions include \link{mxFitFunctionML}, \link{mxFitFunctionAlgebra}, \link{mxFitFunctionRow} and \link{mxFitFunctionR}.

\strong{Datasets built into OpenMx}

\code{OpenMx} comes with over a dozen useful datasets built-in. Discover them using \code{data(package="OpenMx")}, and open them with, 
for example, \code{data("jointdata", package ="OpenMx", verbose= TRUE)}

Please cite the 'OpenMx' package in any publications that make use of it:

Michael C. Neale, Michael D. Hunter, Joshua N. Pritikin, Mahsa Zahery, Timothy R. Brick Robert M.
Kirkpatrick, Ryne Estabrook, Timothy C. Bates, Hermine H. Maes, Steven M. Boker. (2016).
OpenMx 2.0: Extended structural equation and statistical modeling. \emph{Psychometrika}, \strong{81}, 535–549. 
DOI: 10.1007/s11336-014-9435-8

Steven M. Boker, Michael C. Neale, Hermine H. Maes, Michael J. Wilde, Michael Spiegel, Timothy R. Brick,
Jeffrey Spies, Ryne Estabrook, Sarah Kenny, Timothy C. Bates, Paras Mehta, and John Fox. (2011)
OpenMx: An Open Source Extended Structural Equation Modeling Framework. 
\emph{Psychometrika}, 306-317. DOI:10.1007/s11336-010-9200-6

Steven M. Boker, Michael C. Neale, Hermine H. Maes, Michael J. Wilde, Michael Spiegel, Timothy R. Brick, Ryne
Estabrook, Timothy C. Bates, Paras Mehta, Timo von Oertzen, Ross J. Gore, Michael D. Hunter, Daniel C.
Hackett, Julian Karch, Andreas M. Brandmaier, Joshua N. Pritikin, Mahsa Zahery, Robert M. Kirkpatrick, 
Yang Wang, and Charles Driver. (2016) OpenMx 2 User Guide. 
http://openmx.ssri.psu.edu/docs/OpenMx/latest/OpenMxUserGuide.pdf
}
\examples{
library(OpenMx)
data(demoOneFactor)
# ===============================
# = Make and run a 1-factor CFA =
# ===============================

latents  = c("G") # the latent factor
manifests = names(demoOneFactor) # manifest variables to be modeled
# ====================
# = Make the MxModel =
# ====================
m1 <- mxModel("One Factor", type = "RAM", 
	manifestVars = manifests, latentVars = latents, 
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)

# ===============================
# = mxRun it and get a summary! =
# ===============================

m1 = mxRun(m1)
summary(m1)

}
\references{
The OpenMx User's guide can be found at \url{https://openmx.ssri.psu.edu/documentation}
}
