% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalfunctions.R
\name{acc_changes}
\alias{acc_changes}
\title{Accumulates changes in a LULC raster time series}
\usage{
acc_changes(path)
}
\arguments{
\item{path}{The path for the Raster* directory or list of Raster* to be
analysed.}
}
\value{
Two objects, a RasterLayer and a table.
}
\description{
This function calculates the number of times a pixel has changed during
the analysed period. It returns a raster with the number of changes as
pixel value and a table containing the areal percentage of every pixel value
(number of changes).
}
\examples{
\donttest{
url <- "https://zenodo.org/record/3685230/files/SaoLourencoBasin.rda?download=1"
temp <- tempfile()
download.file(url, temp, mode = "wb") # downloading the SaoLourencoBasin dataset
load(temp)
# the acc_changes() function, with the SaoLourencoBasin dataset
acc_changes(SaoLourencoBasin)
}

}
