% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{get_UMVUE_GMS_subset_second_only}
\alias{get_UMVUE_GMS_subset_second_only}
\title{Calculates the "uniformly minimal variance unbiased estimator".}
\usage{
get_UMVUE_GMS_subset_second_only(t, u, r1, n1, n)
}
\arguments{
\item{t}{observed responses in the subset endpoint.}

\item{u}{observed responses in the superset endpoint.}

\item{r1}{critical value for the first stage.}

\item{n1}{sample size for the first stage.}

\item{n}{overall sample size.}
}
\description{
Calculates the "uniformly minimal variance unbiased estimator" (UMVUE) for the true response rate only for the superset endpoint 
(response rate superset endpoint minus response rate subset endpoint) in a subset design.
}
\examples{
\dontrun{
#Setup "sub1"-object
sub1 <- setupSub1Design(pc0 = 0.5, pt0 = 0.6)

#Calculate a subset design
design <- getSolutionsSub1(sub1, skipN1 = FALSE)$Solutions[4,]

#Assume 9 responses in the subset endpoint and 13 responses in the superset endpoint were observed.
t = 9
u = 13
umvue_second <- get_UMVUE_GMS_subset_second_only(t, u, design$r1, design$n1, design$n)
}
}

