% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/os.rank.R
\name{os.rank}
\alias{os.rank}
\title{Visualize R-squared value distribution in target-predictor relationship}
\usage{
os.rank(
  x,
  y,
  method = "linear",
  thresh = 0,
  n.pred = ncol(x),
  upper.xlim = ncol(x)
)
}
\arguments{
\item{x}{A data matrix (row: samples, col: predictors).}

\item{y}{A vector of target value.}

\item{method}{A string to specify the regression function for calculating R-squared values.
"linear" (default), "quadratic" or "cubic" function can be specified.}

\item{thresh}{The lower threshold of R-squared value to be leaved in prediction model (default: 0).}

\item{n.pred}{The number of predictors to be leaved in prediction model (default: ncol(x)).}

\item{upper.xlim}{The upper limitation of x axis (i.e., the number of predictors) in the resulted figure (default: ncol(x)).}
}
\value{
A rank order plot
}
\description{
Visualize R-squared value distribution in target-predictor relationship
}
\examples{
data(Pinus)
train <- os.clean(Pinus$train)
target <- Pinus$target
train <- os.sort(train, target)
os.rank(train, target)
}
\author{
Takahiko Koizumi
}
