% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CohortQueries.R
\name{getCohortDefinitions}
\alias{getCohortDefinitions}
\title{Extract the cohort definition details}
\usage{
getCohortDefinitions(
  connectionHandler,
  schema,
  cgTablePrefix = "cg_",
  targetIds = NULL
)
}
\arguments{
\item{connectionHandler}{A connection handler that connects to the database and extracts sql queries.  Create a connection handler via `ResultModelManager::ConnectionHandler$new()`.}

\item{schema}{The result database schema (e.g., 'main' for sqlite)}

\item{cgTablePrefix}{The prefix used for the cohort generator results tables}

\item{targetIds}{A vector of integers corresponding to the target cohort IDs}
}
\value{
Returns a data.frame with the cohort details
}
\description{
This function extracts all cohort definitions for the targets of interest.
}
\details{
Specify the connectionHandler, the schema and the target cohort IDs
}
\examples{
conDet <- getExampleConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

cohortDef <- getCohortDefinitions(
  connectionHandler = connectionHandler, 
  schema = 'main'
)

}
\seealso{
Other Cohorts: 
\code{\link{getCohortSubsetDefinitions}()},
\code{\link{processCohorts}()}
}
\concept{Cohorts}
