% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_set.r
\name{power_set}
\alias{power_set}
\title{power_set()}
\usage{
power_set(n, ordinal = FALSE)
}
\arguments{
\item{n}{an integer. The cardinal of the set}

\item{ordinal}{a boolean. If TRUE the power set is only composed of subsets of consecutive elements, FALSE (by default) otherwise.}
}
\value{
A list of \eqn{2^n -1} subsets (The empty set is excluded)
}
\description{
A function that gives the power set \eqn{P(S)} of any non empty set S.
}
\examples{
# Powerset of set of 4 elements
fam  =  power_set(4)

# Powerset of set of 4 elements by only keeping
# subsets of consecutive elements
fam2 =  power_set(4,ordinal = TRUE)
}
\references{
Devlin, Keith J (1979). Fundamentals of contemporary set theory. Universitext. Springer-Verlag
}
\author{
Gregory Guernec

\email{otrecod.pkg@gmail.com}
}
