% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaleBar.R
\name{scaleBar}
\alias{scaleBar}
\title{scalebar for OSM plots}
\usage{
scaleBar(map, x = 0.1, y = 0.9, length = 0.2, abslen = NA,
  unit = c("km", "m", "mi", "ft", "yd"), label = unit, type = c("bar",
  "line"), ndiv = NULL, field = "rect", fill = NA, adj = c(0.5, 1.5),
  cex = par("cex"), col = c("black", "white"), targs = NULL, lwd = 7,
  lend = 1, bg = "transparent", mar = c(2, 0.7, 0.2, 3), ...)
}
\arguments{
\item{map}{Map object with map$tiles[[1]]$projection to get the projection from.}

\item{x, y}{Relative position of left end of scalebar. DEFAULT: 0.1, 0.9}

\item{length}{Approximate relative length of bar. DEFAULT: 0.2}

\item{abslen}{Absolute length in \code{unit}s. DEFAULT: NA (computed internally from \code{length})}

\item{unit}{Unit for computation and label.
Possible are kilometer and meter as well as miles, feet and yards.
Note that the returned absolute length is in m. DEFAULT: "km"}

\item{label}{Unit label in plot. DEFAULT: \code{unit}}

\item{type}{Scalebar type: simple \code{'line'} or classical black & white \code{'bar'}. DEFAULT: "bar"}

\item{ndiv}{Number of divisions if \code{type="bar"}. DEFAULT: NULL (computed internally)
Internal selection of \code{ndiv} is based on divisibility of abslen
(modulo) with 1:6. For ties, preferation order is 5>4>3>2>6>1.
For maps with abslen=4000, this means 5 will be chosen,
even though 4 is more appealing. A better algorithm would be welcome!}

\item{field, fill, adj, cex}{Arguments passed to \code{\link[berryFunctions]{textField}}}

\item{col}{Vector of (possibly alternating) colors passed to
\code{\link{segments}} or \code{\link{rect}}. DEFAULT: c("black","white")}

\item{targs}{List of further arguments passed to \code{\link[berryFunctions]{textField}}
like font, col (to differ from bar color), etc. DEFAULT: NULL}

\item{lwd, lend}{Line width and end style passed to \code{\link{segments}}.
DEFAULT: 5,1, which works well in pdf graphics.}

\item{bg}{Background color, e.g. \code{\link[berryFunctions]{addAlpha}(White)}.
DEFAULT: \code{"transparent"} to suppress background.}

\item{mar}{Background margins approximately in letter width/height. DEFAULT: c(2,0.7,0.2,3)}

\item{\dots}{Further arguments passed to \code{\link{segments}} like lty.
(Color for segments is the first value of \code{col}).
Passed to \code{\link{rect}} if \code{type="bar"}, like lwd.}
}
\value{
invisible: coordinates of scalebar and label
}
\description{
Add a scalebar to default or (UTM)-projected OpenStreetMap plots
}
\details{
This uses a hack to get the right distance in the default mercator projected maps.
There, the axes are not in meters, but rather ca 0.7m units (for NW Germany area maps with 20km across).
Accordingly, other packages plot wrong bars:\cr
SDMTools::Scalebar(x=1442638,y=6893871,distance=10000)\cr
raster::scalebar(d=5000, xy=c(1442638,6893871))\cr
mapmisc::scaleBar(map$tiles[[1]]$projection, seg.len=10, pos="center", bg="transparent")\cr
I suppose this function works for other projections as well, but haven't tried yet.
You might need to specify abslen manually with other projections where the axes do not resemble meters at all.
}
\examples{
if(interactive()){
d <- data.frame(long=c(12.95, 12.98, 13.22, 13.11), lat=c(52.40,52.52, 52.36, 52.45))
map <- pointsMap(d, scale=FALSE)
coord <- scaleBar(map)  ; coord
scaleBar(map, bg=berryFunctions::addAlpha("white", 0.7))
scaleBar(map, 0.3, 0.05, unit="m", length=0.1, type="line")
scaleBar(map, 0.3, 0.5, unit="km", abslen=4, ndiv=4, col=4:5, lwd=3)
scaleBar(map, 0.3, 0.8, unit="mi", col="red", targ=list(col="blue", font=2), type="line")

# I don't support subdivisions, but if you wanted them, you could use:
scaleBar(map, 0.12, 0.28, abslen=10, adj=c(0.5, -1.5)  )
scaleBar(map, 0.12, 0.28, abslen=4, adj=c(0.5, -1.5), label="" )
}

\dontrun{ ## Too much downloading time, too error-prone
# Tests around the world
par(mfrow=c(1,2), mar=rep(1,4))
long <- runif(2, -180, 180) ;  lat <- runif(2, -90, 90)
map <- pointsMap(data.frame(long,lat))
map2 <- pointsMap(data.frame(long,lat), map=map, utm=TRUE)
}

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jun 2016
}
\seealso{
\code{\link{pointsMap}}, \code{\link{projectPoints}}
}
\keyword{aplot}
\keyword{spatial}

