% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createOscillators.R
\name{createOscillators}
\alias{createOscillators}
\title{Creates Set of Differential Equations}
\usage{
createOscillators(odenet)
}
\arguments{
\item{odenet}{[\code{ODEnetwork}]\cr
List of class \code{\link{ODEnetwork}}.}
}
\value{
a function with a set of differential equations of order one to use in a numerical step
}
\description{
Creates the set of differential equations of order one from the \code{\link{ODEnetwork}}.
}
\examples{
if (interactive()) {
  masses <- c(1, 2)
  dampers <- diag(c(0.1, 0.5))
  dampers[1, 2] <- 0.05
  springs <- diag(c(4, 10))
  springs[1, 2] <- 6
  odenet <- ODEnetwork(masses, dampers, springs)
  createOscillators(odenet)
}
}
