% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertCoordinates.R
\name{convertCoordinates}
\alias{convertCoordinates}
\title{Converts coordinates between cartesian and polar}
\usage{
convertCoordinates(coords, convertto = "cartesian")
}
\arguments{
\item{coords}{[\code{matrix}]\cr
Matrix with two columns.
Each row contains the pair (x, y) in cartesian coordinates or
(radius, angle) in polar coordinates. The angle is given in radian [0, 2*pi]}

\item{convertto}{[\code{character}]\cr
Defines the target coordinate system for conversion.
Options are "cartesian" and "polar".
Default: "cartesian"}
}
\value{
a matrix with converted coordinates
}
\description{
Converts a given matrix with two rows from polar to cartesian coordinates and vice versa.
}
\examples{
if (interactive()) {
  coordsK <- rbind(c(3, 0), c(1, 3), c(0, 2), c(-3, 1), c(-1, 0), c(-1, -3), c(0, -2), c(2, -3))
  coordsP <- convertCoordinates(coordsK, "polar")
}
}
