# Returns a list (by table) of character vector (by column) of all column comments in an Open Office Base file
# Author : Sylvain Mareschal
odb.comments = function(
		odb,
		tableNames = NULL,
		columnNames = NULL,
		simplify = TRUE
		)
	{
	# Class checks
	if (!is(odb, "odb")) {
		stop("'odb' must be an 'odb' object")
	}
	validObject(odb)
	
	# SAX parsing
	results = xmlEventParse(
		file = paste(odb@directory, "content.xml", sep="/"),
		handlers = list(
			.startElement = function(.name, .attrs, .space, .spaces, .state) {
				if (names(.space) == "db" && .name == "table-representation") {
					# New table
					tableName = iconv(.attrs["name"], from="UTF-8")
					if (is.null(tableNames) || tableName %in% tableNames) {
						# Selects table
						.state$currentTable = tableName
						.state[[ tableName ]] = character(0)
					}
				} else if (names(.space) == "db" && .name == "column") {
					# Currently in a selected table
					if (!is.na(.state$currentTable)) {
						# New column
						columnName = iconv(.attrs["name"], from="UTF-8")
						if (is.null(columnNames) || columnName %in% columnNames) {
							# Selects column
							.state[[ .state$currentTable ]][ columnName ] = iconv(.attrs["help-message"], from="UTF-8")
						}
					}
				}
				return(.state)
			},
			.endElement = function(.name, .space, .spaces, .state) {
				if (.name == "table-representation" && names(.space) == "db") {
					# End of a table
					.state$currentTable = NA
				}
				return(.state)
			},
			.endDocument = function(.state) {
				# State cleaning
				.state$currentTable = NULL
				.state$tableNames = NULL
				.state$columnNames = NULL
				return(.state)
			}
		),
		state = list(
			tableNames = tableNames,
			columnNames = columnNames,
			currentTable = NA
		),
		useDotNames = TRUE,
		useTagName = FALSE,
		saxVersion = 2
	)
	
	# Simplification
	if (simplify) {
		if (length(tableNames) == 1) {
			results = results[[1]]
			if (length(columnNames) == 1) {
				names(results) = NULL
			}
		}
	}
	
	return(results)
}
