\name{draw_elev3D_OCN}
\alias{draw_elev3D_OCN}
\title{Plot 3D map of elevation generated by an OCN}
\usage{
draw_elev3D_OCN(OCN, coarseGrain = c(1,1), colPalette = terrain.colors(1000, alpha = 1),
  addColorbar = TRUE, drawRiver = TRUE, thrADraw = 0.002 *
  OCN$dimX * OCN$dimY * OCN$cellsize^2, riverColor = "#00CCFF",
  theta = -20, phi = 30, expand = 0.05, shade = 0.5)
}
\arguments{
\item{OCN}{List as produced by \code{\link{landscape_OCN}}.}

\item{coarseGrain}{2x1 vector (only effective if \code{chooseCM = FALSE}). For aesthetic purposes, the elevation map can be coarse-grained into a \code{OCN$dimX/coarseGrain[1]}-by-\code{OCN$dimX/coarseGrain[2]} 
domain, where each cell's elevation is the average of elevations of the corresponding \code{coarseGrain[1]}-by-\code{coarseGrain[2]} cells of the original elevation field. 
\code{coarseGrain[1]} and \code{coarseGrain[2]} must be divisors of \code{OCN$dimX} and \code{OCN$dimY}, respectively. \code{coarseGrain = c(2,2)} is often sufficient to achieve a good graphical results for large 
(i.e. at least 100x100 nodes) OCNs.}

\item{colPalette}{Color palette used for the plot.}

\item{addColorbar}{If \code{TRUE}, add colorbar to the plot.}

\item{drawRiver}{If \code{TRUE}, draw the OCN on top of the elevation field.}

\item{thrADraw}{Threshold drainage area value used to display the network.}

\item{riverColor}{Color used to plot the river.}

\item{theta, phi, expand, shade}{Additional parameters passed to the perspective plotting 
function \code{\link{persp}}. \code{theta} expresses azimuthal direction; \code{phi} gives 
colatitude; \code{expand} is the expansion factor for the Z coordinates; \code{shade} controls
the shade at a surface facet.}
}
\value{
No output is returned.
}
\description{
Function that plots the 3D elevation map generated by an OCN.
}
\examples{
# draw 3D representation of a 20x20 OCN with default options
draw_elev3D_OCN(landscape_OCN(OCN_20))

\dontrun{
# 1a) draw the 3D representation of the OCN (without displaying the river  
# and the colorbar) and enhance the aspect ratio of Z coordinates 
# with respect to the default value (the final result will be ugly):
OCN <- landscape_OCN(OCN_400_Allout, displayUpdates = 2) # this takes some minutes  
draw_elev3D_OCN(OCN, expand = 0.2, addColorbar = FALSE, drawRiver = FALSE)

# 1b) same as above, but operate coarse graining  and modify shade for better aesthetics: 
draw_elev3D_OCN(OCN, coarseGrain = c(5,5), expand = 0.2, 
		shade = 0.25, addColorbar = FALSE, drawRiver = FALSE)
}
}
