% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densityExpressions.R
\name{densityExpressions}
\alias{densityExpressions}
\title{Distributions formulas for OBRE}
\usage{
densityExpressions(strDistribution = "normal", eDensityFun = NA)
}
\arguments{
\item{strDistribution}{Distribution input between "normal" (Normal distribution), "logNormal" (logNormal distribution),
"weibull" (Weibull distribution), "logLogistic" (logLogistic distribution), "gpd2" (Generalized Pareto
Distribution with two parameters) or "custom" if the distribution is written by the user.}

\item{eDensityFun}{The density of a two parameters distribution. This should be an expression object, the
two parameters should be called "nTheta1" and "nTheta2", the data "nvData" and its formula should be derivable}
}
\value{
Returns list containing all the symbolic functions.
}
\description{
Function containing expressions of density and cumulative functions, plus the first and second derivatives.
}
\examples{
# Generates the Normal distribution input for OBRE
distrForOBRE <- densityExpressions(strDistribution = "normal")
# The same result can be generated by inserting manually the formula
distrForOBRE <- densityExpressions(strDistribution = "custom",
eDensityFun = expression((exp( -((nvData - nTheta1)^2) / (2 * nTheta2^2)) /
(sqrt(2 * pi) * nTheta2))))

}

