% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormQcsamples.R
\name{NormQcsamples}
\alias{NormQcsamples}
\title{Normalisation methods based on quality control samples}
\usage{
NormQcsamples(featuredata, sampledata, method = c("rlsc"), span = 0,
  deg = 2, lg = TRUE, saveoutput = FALSE,
  outputname = "qcsample_results", ...)
}
\arguments{
\item{featuredata}{featuredata A data frame in the featuredata format. 
This is a dataframe with metabolites in columns and samples in rows.
Unique sample names should be provided as row names.}

\item{sampledata}{A dataframe that contains sample specific information. 
Unique sample names should be provided as row names. For this function, 
this should have, the batch number, the class and the run order, 
with column names 'batch', 'class' and 'order' respectively. 
For the QCs samples, 'class' should be allocated as 0.}

\item{method}{A character string indicating the required normalization
method. In this case, only "\code{rlsc} method as described by Dunn \emph{et al}. (2011).}

\item{span}{The smooting parameter. The default is 0.75.}

\item{deg}{The degree for the polynomial fit. Must be either 0, 1, or 2. Defaults to degree 2 for local polynomial fits.}

\item{lg}{A logical indicating whether the final normalized data matrix needs to be log transformed
after rlsc method. Defaults to TRUE.}

\item{saveoutput}{A logical indicating whether the normalised data matrix and related plots
should be saved.}

\item{outputname}{The name of the output file if the output has to be saved.}

\item{...}{Extra input for the \code{statTarget::shiftCor} function.}
}
\value{
The result is an object of class \code{\link[NormalizeMets:alldata]{alldata}}.
}
\description{
This function is based on the quality control sample based robust LOESS 
(locally estimated scatterplot smoothing) signal correction (QC-RLSC) method 
as described by Dunn \emph{et al}. (2011) and impletemented 
in statTarget: Luan H (2017).
}
\examples{

##Reading the data
data(Didata)
NormQcsamples(sampledata=Didata$sampledata[order(Didata$sampledata$order),],
              featuredata=Didata$featuredata[order(Didata$sampledata$order),],
              saveoutput=FALSE)
              
    
}
\references{
Luan H (2017). statTarget: Statistical Analysis of Metabolite Profile. 
R package version 1.6.0, https://github.com/13479776/statTarget.

Dunn,W.B., Broadhurst,D., Begley,P., Zelena,E., Francis-McIntyre,S., Anderson,N., Brown,M., 
Knowles,J.D., Halsall,A., Haselden,J.N. et al. (2011) Procedures for 
large-scale metabolic profiling of serum and plasma using gas chromatography and 
liquid chromatography coupled to mass spectrometry. Nat. Protoc., 6, 1060-1083
}
\seealso{
\code{statTarget::shiftCor}.
}
\author{
Alysha M De Livera, Gavriel Olshansky
}
