% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dendrogram.r
\name{Dendrogram}
\alias{Dendrogram}
\title{Dendrogram}
\usage{
Dendrogram(featuredata, groupdata, saveplot = FALSE,
  plotname = "dendrogram", savetype = c("png", "bmp", "jpeg", "tiff",
  "pdf"), distmethod = "manhattan", aggmethod = "ward.D",
  main = "Dendrogram", cex = 0.8, clust = FALSE, rect = FALSE,
  nclust = NULL, height = NULL, bordercol = 2, ...)
}
\arguments{
\item{featuredata}{A data frame in the featuredata format. This should have sample
names in the first column to be read as row names and the metabolomics variables 
in the remaining columns.}

\item{groupdata}{A data frame or a table with optional sample names in the 
first column to be read as row names and group names in the following column.}

\item{saveplot}{A logical indication whether to save the dendrogram produced.}

\item{plotname}{Name of the output file if the file is to be saved.}

\item{savetype}{The required format for the plot to be saved in. Threre is a
choice of \code{"png","bmp","jpeg","tiff","pdf"} type files.}

\item{distmethod}{The distance measure to be used. This must be one of
"\code{euclidean}", "\code{maximum}", "\code{manhattan}", "\code{canberra}",
"\code{binary}" or "\code{minkowski}".}

\item{aggmethod}{The agglomeration method to be used. This should be one of
"\code{ward}", "\code{single}", "\code{complete}", "\code{average}",  #ward -> ward.D
"\code{mcquitty}", "\code{median}" or "\code{centroid}".}

\item{main}{Plot title.}

\item{cex}{A numerical value giving the amount by which plotting text and
symbols should be magnified relative to the default.}

\item{clust}{A logical indicating whether the results from heirarchical clustering should be grouped}

\item{rect}{A logical indicatng whether rectanges should be drawn highlighting the groups from clust above}

\item{nclust}{The desired number of clusters for clust or rect.}

\item{height}{The desifed height to obtain clusters for clust or rect. Either nclust or height must be supplied for 
clust or rect.}

\item{bordercol}{If rect=TRUE, a vector with border colors for the rectangles.}

\item{...}{Arguments to be passed on to other methods.}
}
\value{
A dendrogram plot and a list containing an object of class `hclust' and a vector with cluster 
 membership if clust or rect is set to TRUE.
}
\description{
Performs hierarchical cluster analysis given a distance measure 
and an agglomeration method, and produces a dendrogram.
}
\examples{

    data(mixdata) #unadjusted data
    Dendrogram(mixdata$featuredata,mixdata$sampledata[,1])

}
\seealso{
\code{\link[stats]{dist}}, \code{\link[stats]{hclust}}.
}
\author{
Alysha M De Livera, Gavriel Olshansky
}
