% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Nonpareil.R
\docType{class}
\name{Nonpareil.Curve-class}
\alias{Nonpareil.Curve-class}
\title{A single Nonpareil curve. This object can be produced by
\code{Nonpareil.curve} and supports S4 methods \code{plot}, \code{summary},
\code{print}, and \code{predict}. For additional details, see help for
\code{summary.Nonpareil.Curve}.}
\description{
A single Nonpareil curve. This object can be produced by
\code{Nonpareil.curve} and supports S4 methods \code{plot}, \code{summary},
\code{print}, and \code{predict}. For additional details, see help for
\code{summary.Nonpareil.Curve}.
}
\section{Slots}{

\describe{
\item{\code{file}}{Input .npo file.}

\item{\code{label}}{Name of the dataset.}

\item{\code{col}}{Color of the dataset.}

\item{\code{L}}{Read length.}

\item{\code{AL}}{Adjusted read length (same as L for alignment).}

\item{\code{R}}{Number of reads.}

\item{\code{LR}}{Effective sequencing effort used.}

\item{\code{overlap}}{Minimum read overlap.}

\item{\code{ksize}}{K-mer size (for kmer kernel only).}

\item{\code{log.sample}}{Multiplier of the log-sampling (or zero if linear).}

\item{\code{kernel}}{Read-comparison kernel.}

\item{\code{version}}{Nonpareil version used.}

\item{\code{x.obs}}{Rarefied sequencing effort.}

\item{\code{x.adj}}{Adjusted rarefied sequencing effort.}

\item{\code{y.red}}{Rarefied redundancy (observed).}

\item{\code{y.cov}}{Rarefied coverage (corrected).}

\item{\code{y.sd}}{Standard deviation of rarefied coverage.}

\item{\code{y.p25}}{Percentile 25 (1st quartile) of rarefied coverage.}

\item{\code{y.p50}}{Percentile 50 (median) of rarefied coverage.}

\item{\code{y.p75}}{Percentile 75 (3rd quartile) of rarefied coverage.}

\item{\code{kappa}}{Dataset redundancy.}

\item{\code{C}}{Dataset coverage.}

\item{\code{consistent}}{Is the data sufficient for accurate estimation?}

\item{\code{star}}{Coverage considered 'nearly complete'.}

\item{\code{has.model}}{Was the model successfully estimated?}

\item{\code{warning}}{Warnings generated on consistency or model fitting.}

\item{\code{LRstar}}{Projected seq. effort for nearly complete coverage.}

\item{\code{modelR}}{Pearson's R for the estimated model.}

\item{\code{diversity}}{Dataset Nd index of sequence diversity.}

\item{\code{model}}{Fitted sigmoidal model.}

\item{\code{call}}{Call producing this object.}
}}

