% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ValidatePairLinks.R
\name{ValidatePairLinks}
\alias{ValidatePairLinks}
\title{Validates the schema of a links for pairs of relatives}
\usage{
ValidatePairLinks(linksPair)
}
\arguments{
\item{linksPair}{The \code{data.frame} to validate.}
}
\value{
Returns \code{TRUE} if the validation passes. Returns an error (and
associated descriptive message) if it false.
}
\description{
A helper function that verifies the linking dataset contains (A) the
essential columns exist, and (B) at least one row.  It is called by
\code{CreatePairLinks}.

Typical use of \pkg{NlsyLinks} will not require this function, since a
valid paired links are supplied for each supported sample (ie,
\code{\link{Links79Pair}}).

The \pkg{NlsyLinks} uses several types of linking schemas.  This function
validates the type where each relative subject has their own row.

The following four columns must be present: (1) \code{Subect1Tag}, (2)
\code{Subect2Tag}, (3) \code{R}, and (4) \code{MultipleBirth}.  They must
have a \code{numeric} mode/datatype.
}
\examples{
dsSingleLinks <- data.frame(
  ExtendedID=c(1, 1, 1, 2),
  SubjectTag_S1=c(101, 101, 102, 201),
  SubjectTag_S2=c(102, 103, 103, 202),
  R=c(.5, .25, .25, .5),
  RelationshipPath=rep("Gen2Siblings", 4)
)
dsSingleOutcomes <- data.frame(
  SubjectTag=c(101, 102, 103, 201, 202),
  DV1=c(11, 12, 13, 41, 42),
  DV2=c(21, 22, 23, 51, 52))
dsDouble <- CreatePairLinksDoubleEntered(
  outcomeDataset=dsSingleOutcomes,
  linksPairDataset=dsSingleLinks,
  outcomeNames=c("DV1", "DV2"),
  validateOutcomeDataset=TRUE)
dsDouble #Show the 8 rows in the double-entered pair links
summary(dsDouble) #Summarize the variables

ValidatePairLinksAreSymmetric(dsDouble) #Should return TRUE.
}
\seealso{
\code{\link{Links79Pair}}, \code{\link{Links79PairExpanded}},
}
\keyword{validation}

