% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm_main_results.R
\name{plot_main_results}
\alias{plot_main_results}
\title{A plot function to plot multiple rm_main_results}
\usage{
plot_main_results(
  results_dir_name,
  results_to_plot,
  results_to_show = "zero_one_loss",
  type = "line",
  display_names = NULL
)
}
\arguments{
\item{results_dir_name}{A string specifying the directory name that contains
files with DECODING_RESULTS that have rm_main_results as one of the result
metrics.}

\item{results_to_plot}{This can be set to a vector of strings specifying
result_names for the results to plot, or a vector of numbers that contain
the rows in the results_manifest file of the results that should be
compared. The results_manifest file should be created from saving results
using the log_save_results() function. Finally, if this is set to a single
string that is a regular expression, all results in the results_manifest
file result_name variable that match the regular expression will be
plotted.}

\item{results_to_show}{A string specifying the types of results to plot. Options
are: 'zero_one_loss', 'normalized_rank', 'decision_values', or 'all'.}

\item{type}{A string specifying the type of results to plot. Options are
'TCD' to plot a temporal cross decoding matrix or 'line' to create a line
plot of the decoding results as a function of time.}

\item{display_names}{A vector of strings specifying what the labels on the
plots should say for each result. If this is NULL, the result names will be
the names from the manifest file's result_name column, or if these are set
to "No result name set" then the analysisID will be the label.}
}
\value{
Returns a ggplot object that a comparison of main decoding results.
}
\description{
This function can create a line plot of the results or temporal
cross-decoding results for the the zero-one loss, normalized rank and/or
decision values after the decoding analysis has been run (and all results
have been aggregated).
}
\seealso{
Other result_metrics: 
\code{\link{plot.rm_confusion_matrix}()},
\code{\link{plot.rm_main_results}()},
\code{\link{rm_confusion_matrix}()},
\code{\link{rm_main_results}()}
}
\concept{result_metrics}
