% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_functions.R
\name{aggregate_CV_split_results}
\alias{aggregate_CV_split_results}
\title{A result metric (RM) method to aggregate results over cross-validation splits}
\usage{
aggregate_CV_split_results(rm_obj, prediction_results)
}
\arguments{
\item{rm_obj}{The results metric object.}

\item{prediction_results}{A data frame containing the prediction results to
be aggregated over CV splits. The results in this data frame are the
results returned by the CL's \code{\link[=get_predictions]{get_predictions()}} method, along with a
column that specifies which cross-validation split the results come from.
Thus the columns in the \code{prediction_results} data frame are: * \emph{CV}: The
cross-validation split number the results come from. * \emph{test_time}: The
time bin a test point comes from. * \emph{actual_labels}: The actual labels for
what happened on a trial. * \emph{predicted_labels}: The predictions that
classifier made. * \emph{decision_vals.___}: A set of columns with the
decision values for each class returned by the classifier.}
}
\value{
A result-metric object that contains the decoding results aggregated
across cross-validation splits, and thus should take up less memory than
the original \code{prediction_results} that was passed in to this method.
}
\description{
This is a function that must be implemented by all RM objects. This function
is called by the cross-validator results aggregated across all
cross-validation splits. This method should not be called directly but
instead is used internally by the cross-validator (CV) object.
}
\seealso{
\code{\link[=rm_main_results]{rm_main_results()}}, \code{\link[=rm_confusion_matrix]{rm_confusion_matrix()}}
}
\keyword{internal}
