% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{tanhloss}
\alias{tanhloss}
\title{tanhloss}
\usage{
tanhloss(k)
}
\arguments{
\item{k}{Positive numeric value that controls the smoothness of the approximation.}
}
\value{
String defining the tanh loss function in Julia code.
}
\description{
For \code{k} > 0, defines Julia code that defines the loss function,
\deqn{L(\hat{\theta}, \theta) = \tanh\left(\frac{|\hat{\theta} - \theta|}{k}\right),}
which approximates the 0-1 loss as \code{k} tends to zero.

The resulting string is intended to be used in the function \code{\link{train}}, but can also be converted to a callable function using \code{juliaEval}.
}
