% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comm.close.R
\name{comm.close}
\alias{comm.close}
\title{Community Closeness Centrality}
\usage{
comm.close(A, comm, weighted = FALSE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{comm}{A vector or matrix corresponding to the
community each node belongs to}

\item{weighted}{Is the network weighted?
Defaults to \code{FALSE}.
Set to \code{TRUE} for weighted measures}
}
\value{
A vector of community closeness centrality values for each specified
community in the network
(larger values suggest more central positioning)
}
\description{
Computes the community closeness centrality measure of each
community in a network
}
\examples{
# Pearson's correlation only for CRAN checks
A <- TMFG(neoOpen, normal = FALSE)$A

comm <- igraph::walktrap.community(convert2igraph(abs(A)))$membership

#Weighted
result <- comm.close(A, comm)

#Unweighted
result <- comm.close(A, comm, weighted = FALSE)

}
\references{
Christensen, A. P. (in press).
NetworkToolbox: Methods and measures for brain, cognitive, and psychometric network analysis in R.
\emph{The R Journal}, \emph{10}, 422-439.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
