% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt.a.R
\name{adapt.a}
\alias{adapt.a}
\title{Adaptive Alpha}
\usage{
adapt.a(
  test = c("anova", "chisq", "cor", "one.sample", "two.sample", "paired"),
  ref.n = NULL,
  n = NULL,
  alpha = 0.05,
  power = 0.8,
  efxize = c("small", "medium", "large"),
  groups = NULL,
  df = NULL
)
}
\arguments{
\item{test}{Type of statistical test being used.
Can be any of the tests listed}

\item{ref.n}{\emph{n0} in the above equation.
Reference sample size.
If sample size was determined a priori, then the reference
number of participants can be set. This removes the calculation of sample
size based on power}

\item{n}{\emph{n*} in the above equation.
Number of participants in the experiment sample (or per group)}

\item{alpha}{\eqn{\alpha} in the above equation.
Alpha value to adjust.
Defaults to \code{.05}}

\item{power}{Power (\eqn{1 - \beta}) value.
Used to estimate the reference sample size (n0).
Defaults to \code{.80}}

\item{efxize}{Effect size to be used to estimate the reference sample size.
Effect sizes are based on Cohen (1992).
Numeric values can be used.
Defaults to \code{"medium"}}

\item{groups}{Number of groups (only for \code{test = "anova"})}

\item{df}{Number of degrees of freedom (only for \code{test = "chisq"})}
}
\value{
A list containing the following objects:

\item{adapt.a}{The adapted alpha value}

\item{crit.value}{The critical value associated with the adapted alpha value}

\item{orig.a}{The original alpha value}

\item{ref.n}{The reference sample size based on alpha, power, effect size, and test}

\item{exp.n}{The sample size of the experimental sample}

\item{power}{The power used to determine the reference sample size}

\item{test}{The type of statistical test used}
}
\description{
Compute an alpha value adjusted for sample size. The adjusted value is based on
Perez and Pericchi's (2014) formula (equation 11, see below) using a reference sample, which can be
defined a priori or estimated using the sample size calculation from power.

\deqn{\frac{\alpha * \sqrt{n_0 \times (log(n_0) + \chi^{2}_{\alpha}(1))}}{\sqrt{n^* \times (log(n^*) + \chi^{2}_{\alpha}(1))}}}{\alpha * \sqrt(n0 times (log(n0) + \chi^2_\alpha(1))) / \sqrt(n* times (log(n*) + \chi^2_\alpha(1)))}
}
\examples{
#ANOVA
adapt.anova <- adapt.a(test = "anova", n = 200, alpha = .05, power = .80, groups = 3)

#Chi-square
adapt.chisq <- adapt.a(test = "chisq", n = 200, alpha = .05, power = .80, df = 3)

#Correlation
adapt.cor <- adapt.a(test = "cor", n = 200, alpha = .05, power = .80)

#One-sample t-test
adapt.one <- adapt.a(test = "one.sample", n = 200, alpha = .05, power = .80)

#Two-sample t-test
adapt.two <- adapt.a(test = "two.sample", n = 200, alpha = .05, power = .80)

#Paired sample t-test
adapt.paired <- adapt.a(test = "paired", n = 200, alpha = .05, power = .80, efxize = "medium")

}
\references{
Cohen, J. (1992).
A power primer.
\emph{Psychological Bulletin}, \emph{112}, 155-159.

Perez, M. E., & Pericchi, L. R. (2014).
Changing statistical significance with the amount of information: The adaptive \emph{a} significance level.
\emph{Statistics & Probability Letters}, \emph{85}, 20-24.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
