% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comm.str.R
\name{comm.str}
\alias{comm.str}
\title{Community Strength/Degree Centrality}
\usage{
comm.str(A, comm, weighted = TRUE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{comm}{A vector corresponding to the
community each node belongs to}

\item{weighted}{Is the network weighted?
Defaults to \code{TRUE}.
Set to \code{FALSE} for weighted measures}
}
\value{
A vector of community strength/degree centrality values for each specified
community in the network
(larger values suggest more central positioning)
}
\description{
Computes the community strength/degree centrality measure of each
community in a network
}
\examples{
A <- TMFG(neoOpen)$A

comm <- igraph::walktrap.community(convert2igraph(abs(A)))$membership

#Strength
result <- comm.str(A, comm)

#Degree
result <- comm.str(A, comm, weighted = FALSE)

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
