% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{splitsampNet}
\alias{splitsampNet}
\title{Network Construction for splitsamp}
\usage{
splitsampNet(object, method = c("MaST", "TMFG", "LoGo", "threshold"),
  bootmat = FALSE, pB = TRUE, ...)
}
\arguments{
\item{object}{Object output from \code{\link{splitsamp}} function}

\item{method}{A network filtering method.
Defaults to "TMFG"}

\item{bootmat}{Should \code{\link{bootgen}} function be used?
Defaults to FALSE.
Set to TRUE to constuction bootgen networks}

\item{pB}{Should progress bar be displayed?
Defaults to TRUE.
Set to FALSE for no progress bar}

\item{...}{Additional arguments to be passed to the network construction methods}
}
\value{
Returns a list of networks for training (train) and testing (test) samples
}
\description{
Applies a network construction method to samples generated from the splitsamp function
}
\examples{
samples <- splitsamp(neoOpen)

nets <- splitsampNet(samples, method="TMFG")
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
