% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{diversity}
\alias{diversity}
\title{Diversity Coefficient}
\usage{
diversity(A, factors = c("walktrap", "louvain"))
}
\arguments{
\item{A}{Network adjacency matrix}

\item{factors}{A vector of corresponding to each item's factor.
Defaults to "walktrap" for the walktrap community detection algorithm.
Set to "louvain" for the louvain community detection algorithm.
Can also be set to user-specified factors (see examples)}
}
\value{
Returns a list of overall (signs not considered; overall),
negative (negative), and positive (positive) gateway coefficients
}
\description{
Computes the diversity coefficient for each node. The diversity
coefficient measures a node's connections to communitites outside of its
own community. Nodes that have many connections to other communities will
have higher diversity coefficient values. Positive and negative signed weights
for diversity coefficients are computed separately.
}
\examples{
#theoretical factors
factors <- c(rep(1,8), rep(2,8), rep(3,8), rep(4,8), rep(5,8), rep(6,8))

A <- TMFG(neoOpen)$A

gdiv <- diversity(A, factors = factors)

#walktrap factors
wdiv <- diversity(A, factors = "walktrap")
}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}(3), 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
