% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_cascades.R
\name{simulate_cascades}
\alias{simulate_cascades}
\title{Simulate cascades from a diffusion network}
\usage{
simulate_cascades(diffnet, nsim = 1, seed = NULL, max_time = Inf, lambda,
  beta, epsilon, model, partial_cascade = NULL, start_probabilities = NULL)
}
\arguments{
\item{diffnet}{object of class \code{diffnet}.}

\item{nsim}{integer, number of cascades to simulate.}

\item{seed}{integer, seed for random number generator.}

\item{max_time}{numeric, the maximum time after which observations are 
censored}

\item{lambda}{numeric, parameter for diffusion time distribution.}

\item{beta}{numeric, weight for in-network diffusion}

\item{epsilon}{numeric, weight for out of network diffusion}

\item{model}{character, diffusion model to use. One of \code{c("exponential", 
"rayleigh")}.}

\item{partial_cascade}{object of type cascade, containing one partial 
cascades for which further development should be simulated.}

\item{start_probabilities}{a vector of probabilities for each node in diffnet,
to be the node with the first event. If \code{NULL} a node is drawn from
a uniform distribution over all nodes.}
}
\value{
A data frame with three columns. Containing 1) The names of 
    the nodes (\code{"node_name"}) that experience an event in each cascade, 
    2) the event time (\code{"event_time"}) of the corresponding node, 
    3) the cascade identifier \code{"cascade_id"}.
}
\description{
Simulate diffusion cascades based on the generative model underlying netinf
and a diffusion network.
}
\examples{

data(cascades) 
out <- netinf(cascades, trans_mod = "exponential", n_edges = 5, lambda = 1)
simulated_cascades <- simulate_cascades(out, nsim = 10, lambda = 1, 
                                        beta = 0.5, epsilon = 10^-9, 
                                        model = "exponential")
 
# Simulation from partial cascade

}
