% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prox_boot.R
\name{avr_proximity_multiple_target_sets}
\alias{avr_proximity_multiple_target_sets}
\title{avr_proximity_multiple_target_sets}
\usage{
avr_proximity_multiple_target_sets(
  set,
  G,
  ST,
  source,
  N = 1000,
  bins = 100,
  min_per_bin = 20
)
}
\arguments{
\item{set}{Name of the sets you have targets for. (In a drug-target setup, those would be the drugs of interest).}

\item{G}{The original graph (often an interactome).}

\item{ST}{Set-Target data. It is a data.frame with two columns. ID and Target.}

\item{source}{The source nodes (disease genes).}

\item{N}{Number of randomizations.}

\item{bins}{the number os bins for the degree preserving randomization.}

\item{min_per_bin}{the minimum size of each bin.}
}
\value{
proximity and its significance based on the degree preserving randomization.
}
\description{
Calculates the average proximity from a set of targets to a set of source nodes.
It is calculate using a degree preserving randomization. It is calculated as described in
Guney, E. et al (2016) <doi.org:10.1038/ncomms10331>
}
\examples{
set.seed(666)
net  = data.frame(
Node.1 = sample(LETTERS[1:15], 15, replace = TRUE),
Node.2 = sample(LETTERS[1:10], 15, replace = TRUE))
net$value = 1
net =  CoDiNA::OrderNames(net)
net = unique(net)

g <- igraph::graph_from_data_frame(net, directed = FALSE )
S = c("N", "A", "F", "I")
T1 = data.frame(ID = "T1", Target = c("H", "M"))
T2 = data.frame(ID = "T2", Target = c("G", "O"))

avr_proximity_multiple_target_sets(set = c('T1', 'T2'),
G = g,
 source = S,
 ST = rbind(T1,T2),
 bins = 5,
 min_per_bin = 2)


}
