% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disk-matrix-class.R
\docType{class}
\name{disk.matrix}
\alias{as.disk.matrix}
\alias{as.disk.matrix,ANY-method}
\alias{as.disk.matrix,disk.matrix-method}
\alias{as.disk.matrix,matrix-method}
\alias{as.matrix,disk.matrix-method}
\alias{attach.disk.matrix}
\alias{disk.matrix}
\alias{is.disk.matrix}
\alias{serialize.table}
\alias{show,disk.matrix-method}
\title{The 'disk.matrix' class}
\usage{
attach.disk.matrix(file, serialized = TRUE, ...)

serialize.table(file, ...)

is.disk.matrix(x)

as.disk.matrix(x, file, serialize = TRUE)

\S4method{as.disk.matrix}{disk.matrix}(x, file, serialize = TRUE)

\S4method{as.disk.matrix}{matrix}(x, file, serialize = TRUE)

\S4method{as.disk.matrix}{ANY}(x, file, serialize = TRUE)

\S4method{as.matrix}{disk.matrix}(x)

\S4method{show}{disk.matrix}(object)
}
\arguments{
\item{file}{for \code{attach.disk.matrix} the file name of a matrix on disk. 
For \code{as.disk.matrix} the file name to save the matrix to. For 
\code{serialize.table} the file name of a matrix in table format on disk.}

\item{serialized}{determines how the matrix will be loaded from disk into R
by \code{as.matrix}. If \code{TRUE}, the \code{readRDS} function 
will be used. If \code{FALSE}, the \code{read.table} function will 
be used.}

\item{...}{arguments to be used by \code{read.table} when reading in matrix 
data from a file in table format.}

\item{x}{for \code{as.matrix} a \code{disk.matrix} object to load into R. 
For \code{as.disk.matrix} an object to convert to a \code{disk.matrix}. For 
\code{is.disk.matrix} an object to check if its a \code{disk.matrix}.}

\item{serialize}{determines how the matrix is saved to disk by 
\code{as.disk.matrix}. If \code{TRUE} it will be stored as a serialized R 
object using \code{saveRDS}. If \code{FALSE} it will be stored as a 
tab-separated file using \code{write.table}.}

\item{object}{a \code{'disk.matrix'} object.}
}
\value{
A \code{disk.matrix} object (\code{attach.disk.matrix}, \code{as.disk.matrix}),
a \code{matrix} (\code{as.matrix}), the file path to a serialized matrix
(\code{serialize.table}), or a \code{TRUE} or \code{FALSE} indicating 
whether an object is a \code{disk.matrix} (\code{is.disk.matrix}).
}
\description{
A \code{'disk.matrix'} contains a file path to a matrix stored on disk,
along with meta data for how to read that file. This allows \pkg{NetRep}
to load datasets into RAM only when required, i.e. one at a time. This 
significantly reduces the memory usage of R when analysing large datasets.
\code{'disk.matrix'} objects may be supplied instead of \code{'matrix'} 
objects in the input list arguments \code{'network'}, \code{'data'}, and 
\code{'correlation'}, which are common to most of \pkg{NetRep}'s functions.
}
\details{
Matrices may either be stored as regular table files that can be read by
\code{\link{read.table}}, or as serialized R objects that can be read by
\code{\link{readRDS}}. Serialized objects are much faster to load, but 
cannot be read by other programs. 

The \code{attach.disk.matrix} function creates a \code{disk.matrix} object
from a file path. The \code{as.matrix} function will load the data from disk
into the R session as a regular \code{\link{matrix}} object.

The \code{as.disk.matrix} function converts a matrix into a 
\code{disk.matrix} by saving its contents to the specified \code{file}. The
\code{serialize} argument determines whether the data is stored as a 
serialized R object or as a tab-separated file (i.e. \code{sep="\\t"}). We
recommend storing the matrix as a serialized R object unless disk space is
a concern. More control over the storage format can be obtained by using
\code{saveRDS} or \code{write.table} directly.

The \code{serialize.matrix} function converts a file in table format to a
serialized R object with the same file name, but with the ".rds" extension.
}
\section{Slots}{

\describe{
\item{\code{file}}{the name of the file where the matrix is saved.}

\item{\code{read.func}}{either \code{"read.table"} or \code{"readRDS"}.}

\item{\code{func.args}}{a list of arguments to be supplied to the \code{'read.func'}.}
}}
\section{Warning}{

\code{attach.disk.matrix} does not check whether the specified file can be
read into R. \code{as.matrix} will fail and throw an error if this is the
case.
}

