% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{delay-data}
\alias{delay-data}
\alias{delayAth}
\alias{delayGoe}
\title{Delay propagation data examples simulated by LinTim software}
\source{
Public transportation network datasets are generated by LinTim software (Integrated Optimization in Public Transportation; \url{https://www.lintim.net/index.php?go=data&lang=en}).
}
\description{
Delay propagation data examples simulated by LinTim software

\code{delayAth} Delay propagation data generated on the Athens metro network by LinTim software

\code{delayGoe} Delay propagation data generated on the Goettingen bus system by LinTim software
}
\details{
\code{delayAth} Delay data on the Athens metro network. Propagation simulation under consideration of secruity distances and fixed-waiting time delay management. 'data.frame' with 510 observations (10 sequential time pictures for delay spreading pattern from 51 stations) of 53 variables (\code{k0} true source, \code{time}, delays at 51 stations).

\code{delayGoe} Delay data on the directed Goettingen bus system. Progation simulation under consideration of secruity distances and fixed-waiting time delay management. 'data.frame' with 2570 observations (10 sequential time pictures for delay spreading pattern from 257 stations) of 259 variables (\code{k0} true source, \code{time}, delays at 257 stations).
}
\examples{
\donttest{ 
# compute effective distance
data(ptnAth)
athnet <- igraph::as_adjacency_matrix(ptnAth, sparse=FALSE)
p <- athnet/rowSums(athnet)
eff <- eff_dist(p)
# apply source estimation
data(delayAth)
res <- plyr::alply(.data=delayAth[,-c(1:2)], .margins=1, .fun=origin_edm, distance=eff,
             silent=TRUE, .progress='text')
perfAth <- plyr::ldply(Map(performance, x = res, start = as.list(delayAth$k0),  
                     list(graph = ptnAth)))
}
\donttest{ 
# compute effective distance
data(ptnGoe)
goenet <- igraph::as_adjacency_matrix(ptnGoe, sparse=FALSE)
p <- goenet/rowSums(goenet)
eff <- eff_dist(p)
# apply source estimation
data(delayGoe)
res <- plyr::alply(.data=delayGoe[,-c(1:2)], .margins=1, .fun=origin_edm, distance=eff,
             silent=TRUE, .progress='text')
perfGoe <- plyr::ldply(Map(performance, x = res, start = as.list(delayGoe$k0), 
                     list(graph = ptnGoe)))
}
}
\references{
Manitz, J., J. Harbering, M. Schmidt, T. Kneib, and A. Schoebel (2017): Source Estimation for Propagation Processes on Complex Networks with an Application to Delays in Public Transportation Systems. Journal of Royal Statistical Society C (Applied Statistics), 66: 521-536.
}
\seealso{
\code{\link{ptn-data}}
}
\author{
Jonas Harbering
}
\keyword{data}
