% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turtle-functions.R
\docType{methods}
\name{patchHere}
\alias{patchHere}
\alias{patchHere,worldNLR,agentMatrix-method}
\title{Patches here}
\usage{
patchHere(world, turtles)

\S4method{patchHere}{worldNLR,agentMatrix}(world, turtles)
}
\arguments{
\item{world}{WorldMatrix or worldArray object.}

\item{turtles}{AgentMatrix object representing the moving agents.}
}
\value{
Matrix (ncol = 2) with the first column "pxcor" and the second column
        "pycor" representing the coordinates of the patches at the \code{turtles}
        location. The order of the patches follows the order of the \code{turtles}.
}
\description{
Report the coordinates of the patches under the \code{turtles}
locations.
}
\details{
If a turtle is located outside of the \code{world}'s extent,
         \code{NA} are returned
         for the patch coordinates.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 9, minPycor = 0, maxPycor = 9)
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10))
patchHere(world = w1, turtles = t1)


}
\references{
Wilensky, U. 1999. NetLogo. http://ccl.northwestern.edu/netlogo/.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#patch-here}
}
\author{
Sarah Bauduin
}
