% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentset-functions.R
\docType{methods}
\name{nOf}
\alias{nOf}
\alias{nOf,matrix,numeric-method}
\title{N random agents}
\usage{
nOf(agents, n)

\S4method{nOf}{matrix,numeric}(agents, n)
}
\arguments{
\item{agents}{Matrix (ncol = 2) with the first column "pxcor" and the second
              column "pycor" representing the patches coordinates, or

              Matrix (ncol = 3) with the first column "pxcor" and the second
              column "pycor" representing the patches coordinates and the
              third column "id", or

              AgentMatrix object representing the moving agents, or

              Matrix (ncol = 2) with the first column "whoTurtles" and the
              second column "id".}

\item{n}{Integer. Number of patches or turtles to select from \code{agents}.}
}
\value{
Matrix (ncol = 2, nrow = \code{n}) with the first column "pxcor"
        and the second  column "pycor" representing the coordinates of the
        selected patches from \code{agents}, or

        Matrix (ncol = 2) with the first column "pxcor"
        and the second  column "pycor" representing the coordinates of the
        selected patches from \code{agents}, \code{n} per individual "id", or

        AgentMatrix (nrow = \code{n}) representing the turtles
        selected from \code{agents},

        Integer. Vector of "who" numbers for the selected turtles from
        \code{agents}, \code{n} per individual "id".
}
\description{
Report \code{n} patches or turtles randomly selected among \code{agents}.
}
\details{
\code{n} must be less or equal the number of patches
         or turtles in \code{agents}.

         If \code{agents} is a matrix with ncol = 3, the selection of \code{n}
         random patches is done per individual "id". The order of the patches
         coordinates returned follow the order of "id".
         If \code{agents} is a matrix (ncol = 2) with columns "whoTurtles" and
         "id", the selection of \code{n} random turtles (defined by their "whoTurtles")
         is done per individual "id". The order of the "who" numbers returned
         follow the order of "id".
}
\examples{
# Patches
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4)
pSelect <- nOf(agents = patches(w1), n = 5)

# Turtles
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10))
tSelect <- nOf(agents = t1, n = 2)


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#n-of}
}
\author{
Sarah Bauduin
}
