% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/element_plot.R
\name{element.plot}
\alias{element.plot}
\title{Plots the observed and expected probabilities for the basic elements based on the condition}
\usage{
element.plot(netfacs.data)
}
\arguments{
\item{netfacs.data}{object resulting from netfacs() function}
}
\value{
Function returns a ggplot showing for each element the observed probability and expected probability
}
\description{
The function takes all single elements in a netfacs object, and plots the observed value and the expected value based on all randomisations
}
\examples{
### how do angry facial expressions differ from non-angry ones?
data(emotions_set)
angry.face <- netfacs(
  data = emotions_set[[1]],
  condition = emotions_set[[2]]$emotion,
  test.condition = "anger",
  ran.trials = 100,
  combination.size = 2
)
# plot all
element.plot(netfacs.data = angry.face)
}
