% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{g_cfar2h}
\alias{g_cfar2h}
\title{Generate a CFAR(2) Process with Heteroscedasticity and Irregular Observation Locations}
\usage{
g_cfar2h(
  tmax = 1001,
  grid = 1000,
  rho = 1,
  min_obs = 40,
  pois = 5,
  phi_func1 = NULL,
  phi_func2 = NULL,
  weight = NULL,
  ini = 100
)
}
\arguments{
\item{tmax}{length of time.}

\item{grid}{the number of grid points used to construct the functional time series.}

\item{rho}{parameter for O-U process (noise process).}

\item{min_obs}{the minimum number of observations at each time.}

\item{pois}{the mean for Poisson distribution. The number of observations at each follows a Poisson distribution plus min_obs.}

\item{phi_func1}{the first convolutional function. Default is 0.5*x^2+0.5*x+0.13.}

\item{phi_func2}{the second convolutional function. Default is 0.7*x^4-0.1*x^3-0.15*x.}

\item{weight}{the weight function to determine the standard deviation of O-U process (noise process). Default is 1.}

\item{ini}{the burn-in period.}
}
\value{
The function returns a list with components:
\item{cfar2}{a tmax-by-(grid+1) matrix following a CFAR(1) process.}
\item{epsilon}{the innovation at time tmax.}
}
\description{
Generate a convolutional functional autoregressive process of order 2 with heteroscedasticity, irregular observation locations.
}
\examples{
phi_func1= function(x){
return(0.5*x^2+0.5*x+0.13)
}
phi_func2= function(x){
return(0.7*x^4-0.1*x^3-0.15*x)
}
y=g_cfar2h(200,1000,1,40,5,phi_func1=phi_func1,phi_func2=phi_func2)
}
\references{
Liu, X., Xiao, H., and Chen, R. (2016) Convolutional autoregressive models for functional time series. \emph{Journal of Econometrics}, 194, 263-282.
}
