% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmNiWpdf.R
\name{mmNiWpdf}
\alias{mmNiWpdf}
\title{multivariate Normal inverse Wishart probability density function for multiple inputs}
\usage{
mmNiWpdf(mu, Sigma, U_mu0, U_kappa0, U_nu0, U_lambda0, Log = TRUE)
}
\arguments{
\item{mu}{data matrix of dimension \code{p x n}, \code{p} being the dimension of the
data and n the number of data points, where each column is an observed mean vector.}

\item{Sigma}{list of length \code{n} of observed variance-covariance matrices,
each of dimensions \code{p x p}.}

\item{U_mu0}{mean vectors matrix of dimension \code{p x K}, \code{K} being the number of
distributions for which the density probability has to be evaluated}

\item{U_kappa0}{vector of length \code{K} of scale parameters.}

\item{U_nu0}{vector of length \code{K} of degree of freedom parameters.}

\item{U_lambda0}{list of length \code{K} of variance-covariance matrices,
each of dimensions \code{p x p}.}

\item{Log}{logical flag for returning the log of the probability density
function. Defaults is \code{TRUE}.}
}
\value{
matrix of densities of dimension K x n
}
\description{
multivariate Normal inverse Wishart probability density function for multiple inputs
}

