% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARMA.R
\name{NNS.ARMA}
\alias{NNS.ARMA}
\title{NNS ARMA}
\usage{
NNS.ARMA(variable, h = 1, training.set = NULL,
  seasonal.factor = TRUE, weights = NULL, best.periods = 2,
  negative.values = FALSE, method = "nonlin", dynamic = FALSE,
  plot = TRUE, seasonal.plot = TRUE, intervals = FALSE,
  ncores = NULL)
}
\arguments{
\item{variable}{a numeric vector.}

\item{h}{integer; 1 (default) Number of periods to forecast.}

\item{training.set}{numeric; \code{NULL} (defualt) Sets the number of variable observations

 \code{(variable[1 : training.set])} to monitor performance of forecast over in-sample range.}

\item{seasonal.factor}{logical or integer(s); \code{TRUE} (default) Automatically selects the best seasonal lag from the seasonality test.  To use weighted average of all seasonal lags set to \code{(seasonal.factor = FALSE)}.  Otherwise, directly input known frequency integer lag to use, i.e. \code{(seasonal.factor = 12)} for monthly data.  Multiple frequency integers can also be used, i.e. \code{(seasonal.factor = c(12, 24, 36))}}

\item{weights}{numeric; \code{NULL} (default) sets the weights of the \code{seasonal.factor} vector when specified as integers.  If \code{(weights = NULL)} each \code{seasonal.factor} is weighted on its \link{NNS.seas} result and number of observations it contains.}

\item{best.periods}{integer; [2] (default) used in conjuction with \code{(seasonal.factor = FALSE)}, uses the \code{best.periods} number of detected seasonal lags instead of \code{ALL} lags when

\code{(seasonal.factor = FALSE)}.}

\item{negative.values}{logical; \code{FALSE} (default) If the variable can be negative, set to
\code{(negative.values = TRUE)}.  If there are negative values within the variable, \code{negative.values} will automatically be detected.}

\item{method}{options: ("lin", "nonlin", "both"); \code{"nonlin"} (default)  To select the regression type of the component series, select \code{(method = "both")} where both linear and nonlinear estimates are generated.  To use a nonlineaer regression, set to
\code{(method = "nonlin")}; to use a linear regression set to \code{(method = "lin")}.}

\item{dynamic}{logical; \code{FALSE} (default) To update the seasonal factor with each forecast point, set to \code{(dynamic = TRUE)}.  The default is \code{(dynamic = FALSE)} to retain the original seasonal factor from the inputted variable for all ensuing \code{h}.}

\item{plot}{logical; \code{TRUE} (default) Returns the plot of all periods exhibiting seasonality and the \code{variable} level reference in upper panel.  Lower panel returns original data and forecast.}

\item{seasonal.plot}{logical; \code{TRUE} (default) Adds the seasonality plot above the forecast.  Will be set to \code{FALSE} if no seasonality is detected or \code{seasonal.factor} is set to an integer value.}

\item{intervals}{logical; \code{FALSE} (default) Plots the surrounding forecasts around the final estimate when \code{(intervals = TRUE)} and \code{(seasonal.factor = FALSE)}.  There are no other forecasts to plot when a single \code{seasonal.factor} is selected.}

\item{ncores}{integer; value specifying the number of cores to be used in the parallelized  procedure. If NULL (default), the number of cores to be used is equal to half the number of cores of the machine - 1.}
}
\value{
Returns a vector of forecasts of length \code{(h)}.
}
\description{
Autoregressive model incorporating nonlinear regressions of component series.
}
\note{
For monthly data series, increased accuracy may be realized from forcing seasonal factors to multiples of 12.  For example, if the best periods reported are: \{37, 47, 71, 73\}  use
\code{(seasonal.factor = c(36, 48, 72))}.

\code{(seasonal.factor = FALSE)} can be a very comutationally expensive exercise due to the number of seasonal periods detected.

If error encountered when \code{(seasonal.factor = TRUE)}:

\code{"NaNs produced Error in seq.default(length(variable)+1, 1, -lag[i]) :
 wrong sign in 'by' argument"}

use the combination of \code{(seasonal.factor = FALSE, best.periods = 1)}.
}
\examples{

## Nonlinear NNS.ARMA using AirPassengers monthly data and 12 period lag
\dontrun{
NNS.ARMA(AirPassengers, h = 45, training.set = 100, seasonal.factor = 12, method = "nonlin")

## Linear NNS.ARMA using AirPassengers monthly data and 12, 24, and 36 period lags
NNS.ARMA(AirPassengers, h = 45, training.set = 120, seasonal.factor = c(12, 24, 36), method = "lin")

## Nonlinear NNS.ARMA using AirPassengers monthly data and 2 best periods lag
NNS.ARMA(AirPassengers, h = 45, training.set = 120, seasonal.factor = FALSE, best.periods = 2)}

}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\author{
Fred Viole, OVVO Financial Systems
}
