% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Normalization.R
\name{NNS.norm}
\alias{NNS.norm}
\title{NNS Normalization}
\usage{
NNS.norm(A, chart.type = NULL, Linear = F)
}
\arguments{
\item{A}{Matrix of variables.}

\item{chart.type}{Defaults to \code{chart.type=NULL}.  \code{chart.type='l'} for line, \code{chart.type='b'} for boxplot.}

\item{Linear}{Performs a linear scaling normalization, resulting in eqaul means for all variables.  Defaults to \code{Linear=FALSE}.}
}
\value{
Returns a matrix of normalized values.
}
\description{
Normalizes a matrix of variables based on nonlinear scaling normalization method.
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100)
A<-cbind(x,y)
NNS.norm(A)
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{normalization}

