% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplePars.R
\name{samplePars}
\alias{samplePars}
\title{Sample model parameters using `mvrnorm` or the `simpar` package}
\usage{
samplePars(file.mod, nsims, method, seed.R, format = "ext", as.fun)
}
\arguments{
\item{file.mod}{Path to model control stream. Will be used for
both `NMreadExt()` and `NMreadCov()`, and extension will
automatically be replaced by `.ext` and `.cov`.}

\item{nsims}{Number of sets of parameter values to
generate. Passed to `simpar`.}

\item{method}{The sampling method. Options are "mvrnorm" and
"simpar". Each have pros and cons. Notice that both methods
are fully automated as long as ".ext" and ".cov" files are
available.}

\item{seed.R}{seed value passed to set.seed().}

\item{format}{The returned data set format "ext" (default) or
"wide". "ext" is a long-format, similar to what
`NMdata::NMreadExt()` returns.}

\item{as.fun}{The default is to return data as a data.frame. Pass
a function (say `tibble::as_tibble`) in as.fun to convert to
something else. If data.tables are wanted, use
as.fun="data.table". The default can be configured using
NMdataConf.}
}
\value{
A table with sampled model parameters
}
\description{
Sample model parameters using `mvrnorm` or the `simpar` package
}
\details{
This function was originally create by Sanaya Shroff and
    Philip Delff for sampling using `simpar`. It has since been
    generalized to support sampling with `mvrnorm()` too.
}
