% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_curds.R
\name{nlm_curds}
\alias{nlm_curds}
\title{nlm_curds}
\usage{
nlm_curds(curds, recursion_steps, wheyes = NULL, resolution = 1)
}
\arguments{
\item{curds}{[\code{numerical(x)}]\cr
Vector with percentage/s to fill with curds (fill with habitat (value ==
TRUE)).}

\item{recursion_steps}{[\code{numerical(x)}]\cr
Vector of successive cutting steps for the blocks (split 1 block into \code{x}
blocks).}

\item{wheyes}{[\code{numerical(x)}]\cr
Vector with percentage/s to fill with wheys, which fill matrix in an
additional step with habitat.}

\item{resolution}{[\code{numerical(1)}]\cr
Resolution of the resulting raster.}
}
\value{
raster
}
\description{
Simulates a random curd neutral landscape model with optional wheys.
}
\details{
Random curdling recursively subdivides the plane into blocks.
At each level of the recursion, a fraction of the blocks are declared as
habitat (value == TRUE) while the remaining blocks continue to be defined as matrix (value == FALSE) and enter the next recursive cycle.

The optional argument (\code{wheyes}) allows wheys to be added, in which a set proportion of cells that were
declared matrix (value == FALSE) during recursion, are now set as habitat cells (value == TRUE).

If \deqn{curds_{1} = curds_{2} = recursion_steps_{2} = ... = curds_{n} =
recursion_steps_{n}} the models resembles a binary random map.

Note that you can not set ncol and nrow with this landscape algorithm.
The amount of cells and hence dimension of the raster is given by the vector product of the recursive steps.
}
\examples{

# simulate random curdling
(random_curdling <- nlm_curds(curds = c(0.5, 0.3, 0.6),
                              recursion_steps = c(32, 6, 2)))

# simulate wheyed curdling
(wheyed_curdling <- nlm_curds(curds = c(0.5, 0.3, 0.6),
                              recursion_steps = c(32, 6, 2),
                              wheyes = c(0.1, 0.05, 0.2)))
\dontrun{
# Visualize the NLMs
landscapetools::show_landscape(random_curdling)
landscapetools::show_landscape(wheyed_curdling)
}

}
\references{
Keitt TH. 2000. Spectral representation of neutral landscapes.
\emph{Landscape Ecology} 15:479-493.

Szaro, Robert C., and David W. Johnston, eds. Biodiversity in managed
landscapes: theory and practice. \emph{Oxford University Press}, USA, 1996.
}
