% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlm_fBm.R
\name{nlm_fBm}
\alias{nlm_fBm}
\title{nlm_fBm}
\usage{
nlm_fBm(ncol, nrow, resolution = 1, fract_dim = 1, user_seed = NULL,
  rescale = TRUE)
}
\arguments{
\item{ncol}{[\code{numerical(1)}]\cr
Number of columns for the raster.}

\item{nrow}{[\code{numerical(1)}]\cr
Number of rows for the raster.}

\item{resolution}{[\code{numerical(1)}]\cr
Resolution of the raster.}

\item{fract_dim}{[\code{numerical(1)}]\cr
numeric in (0,2]; refers to the fractal dimension of the process}

\item{user_seed}{[\code{numerical(1)}]\cr
Set Seed for simulation}

\item{rescale}{[\code{numeric(1)}]\cr
If \code{TRUE} (default), the values are rescaled between 0-1.}
}
\value{
RasterLayer
}
\description{
Simulates two-dimensional fractional brownian motion model.
}
\details{
Neutral landscapes are generated using fractional Brownian motion,
 an extension of Brownian motion in which the amount of correlation between
  steps is controlled by the Hurst coefficient H. An H of 1 produces a
   relatively smooth surface while an H of 0 produces a rough, uncorrelated,
    surface. Implementation of this method is limited to landscapes with
     extents less than 90 by 90 cells.
}
\examples{
# simulate fractional brownian motion
(fBm_raster  <- nlm_fBm(ncol = 20, nrow = 30, fract_dim = 0.8))
\dontrun{
# visualize the NLM
util_plot(fBm_raster)
}
}
\references{
Martin Schlather, Alexander Malinowski, Peter J. Menck, Marco Oesting,
Kirstin Strokorb (2015). Analysis, Simulation and Prediction of Multivariate
Random Fields with Package RandomFields. \emph{Journal of Statistical
Software}, 63(8), 1-25. URL http://www.jstatsoft.org/v63/i08/.
}
