% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{snapShot}
\alias{snapShot}
\title{Snapshot}
\usage{
snapShot(NGLVieweR_proxy, fileName = "Snapshot", param = list())
}
\arguments{
\item{NGLVieweR_proxy}{A NGLVieweR object.}

\item{fileName}{Optional name for Snapshot (default = "Snapshot").}

\item{param}{Of type list, can be; antialias \code{TRUE/FALSE}, trim \code{TRUE/FALSE}, transparent \code{TRUE/FALSE} or scale \code{numeric}.
For a full list of options, see "makeImage" and "ImageParameters" in the official \href{http://nglviewer.org/ngl/api/}{NGL.js} manual.}
}
\value{
API call containing \code{NGLVieweR} \code{id} and list of message parameters.
}
\description{
Make a snapshot of a NGLVieweR object in Shinymode.
}
\examples{
\dontrun{
NGLVieweR_proxy("structure") \%>\%
snapShot("Snapshot", param = list(
                               antialias = TRUE,
                               trim = TRUE,
                               transparent = TRUE,
                               scale = 1))
}

if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    titlePanel("Viewer with API inputs"),
    sidebarLayout(
      sidebarPanel(
        actionButton("snapshot", "Snapshot"),
      ),
      mainPanel(
        NGLVieweROutput("structure")
      )
    )
  )
  server <- function(input, output) {
    output$structure <- renderNGLVieweR({
      NGLVieweR("7CID") \%>\%
        addRepresentation("cartoon",
          param = list(
            name = "cartoon",
            color = "residueindex"
          )
        )
    })
    observeEvent(input$snapshot, {
      NGLVieweR_proxy("structure") \%>\%
        snapShot("Snapshot",
          param = list(
            antialias = TRUE,
            trim = TRUE,
            transparent = TRUE,
            scale = 1
          )
        )
    })
  }
  shinyApp(ui, server)
}
}
\seealso{
\code{\link[=NGLVieweR_example]{NGLVieweR_example()}} See example "snapshot".

Other options: 
\code{\link{setFocus}()},
\code{\link{setQuality}()},
\code{\link{updateFocus}()},
\code{\link{updateFullscreen}()}
}
\concept{options}
