% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autotune_mice.R
\name{formula_creating}
\alias{formula_creating}
\title{Creating a formula for use in mice imputation evaluation.}
\usage{
formula_creating(df, col_miss, col_no_miss, col_type, percent_of_missing)
}
\arguments{
\item{df}{data.frame. Data frame to impute missing values with column names.}

\item{col_miss}{character vector. Names of columns with NA.}

\item{col_no_miss}{character vector. Names of columns without NA.}

\item{col_type}{character vector. A vector containing column type names.}

\item{percent_of_missing}{numeric vector. Vector contatining percent of missing data in columns for example  c(0,1,0,0,11.3,..)}
}
\value{
List with formula object[1] and information if its no numeric value in dataset[2].
}
\description{
Function is used in \code{\link{autotune_mice}} but can be use sepraetly.
}
\details{
Function create a formula as follows. It creates one of the formulas its next possible formula impossible possible formula is created: \cr 1. Numeric no missing ~ 3 numeric with most missing \cr 2. Numeric no missing ~ all available numeric with missing \cr 3. Numeric with less missing ~ 3 numeric with most missing \cr 4. Numeric with less missing ~ all available numeric with missing \cr 5. No numeric no missing ~ 3 most missing no numeric \cr 6. No numeric no missing ~ all available no numeric with missing \cr 7. No numeric with less missing ~ 3 no numeric with most missing \cr 8. No numeric with less missing ~ all available no numeric with missing.
\cr For example, if its impossible to create formula 1 and 2 formula 3 will be created but if it's possible to create formula 1 and 5 formula 1 will be created.
}
\references{
Stef van Buuren, Karin Groothuis-Oudshoorn (2011). mice: Multivariate Imputation by Chained Equations in R. Journal of Statistical Software, 45(3), 1-67. URL https://www.jstatsoft.org/v45/i03/.
}
