/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.distance;

import java.util.Iterator;
import org.apache.mahout.common.distance.WeightedDistanceMeasure;
import org.apache.mahout.math.Vector;

public class TanimotoDistanceMeasure
extends WeightedDistanceMeasure {
    @Override
    public double distance(Vector a, Vector b) {
        double denominator;
        double ab;
        if (this.getWeights() != null) {
            ab = this.dot(b, a);
            denominator = this.dot(a, a) + this.dot(b, b) - ab;
        } else {
            ab = b.dot(a);
            denominator = a.getLengthSquared() + b.getLengthSquared() - ab;
        }
        if (denominator < ab) {
            denominator = ab;
        }
        if (denominator > 0.0) {
            return 1.0 - ab / denominator;
        }
        return 0.0;
    }

    public double dot(Vector a, Vector b) {
        Vector.Element el;
        boolean sameVector = a == b;
        Iterator it = a.iterateNonZero();
        Vector weights = this.getWeights();
        double dot = 0.0;
        while (it.hasNext() && (el = (Vector.Element)it.next()) != null) {
            double elementValue = el.get();
            double value = elementValue * (sameVector ? elementValue : b.getQuick(el.index()));
            dot += (value *= weights.getQuick(el.index()));
        }
        return dot;
    }

    @Override
    public double distance(double centroidLengthSquare, Vector centroid, Vector v) {
        return this.distance(centroid, v);
    }
}

