/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.common.iterator.CountingIterator;

public final class BooleanItemPreferenceArray
implements PreferenceArray {
    private final long[] ids;
    private long id;

    public BooleanItemPreferenceArray(int size) {
        this.ids = new long[size];
        this.id = Long.MIN_VALUE;
    }

    public BooleanItemPreferenceArray(List<? extends Preference> prefs, boolean forOneUser) {
        this(prefs.size());
        int size = prefs.size();
        for (int i = 0; i < size; ++i) {
            Preference pref = prefs.get(i);
            this.ids[i] = forOneUser ? pref.getItemID() : pref.getUserID();
        }
        if (size > 0) {
            this.id = forOneUser ? prefs.get(0).getUserID() : prefs.get(0).getItemID();
        }
    }

    private BooleanItemPreferenceArray(long[] ids, long id) {
        this.ids = ids;
        this.id = id;
    }

    @Override
    public int length() {
        return this.ids.length;
    }

    @Override
    public Preference get(int i) {
        return new PreferenceView(i);
    }

    @Override
    public void set(int i, Preference pref) {
        this.id = pref.getItemID();
        this.ids[i] = pref.getUserID();
    }

    @Override
    public long getUserID(int i) {
        return this.ids[i];
    }

    @Override
    public void setUserID(int i, long userID) {
        this.ids[i] = userID;
    }

    @Override
    public long getItemID(int i) {
        return this.id;
    }

    @Override
    public void setItemID(int i, long itemID) {
        this.id = itemID;
    }

    @Override
    public long[] getIDs() {
        return this.ids;
    }

    @Override
    public float getValue(int i) {
        return 1.0f;
    }

    @Override
    public void setValue(int i, float value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sortByUser() {
        Arrays.sort(this.ids);
    }

    @Override
    public void sortByItem() {
    }

    @Override
    public void sortByValue() {
    }

    @Override
    public void sortByValueReversed() {
    }

    @Override
    public boolean hasPrefWithUserID(long userID) {
        for (long id : this.ids) {
            if (userID != id) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPrefWithItemID(long itemID) {
        return this.id == itemID;
    }

    @Override
    public BooleanItemPreferenceArray clone() {
        return new BooleanItemPreferenceArray((long[])this.ids.clone(), this.id);
    }

    public int hashCode() {
        return (int)(this.id >> 32) ^ (int)this.id ^ Arrays.hashCode(this.ids);
    }

    public boolean equals(Object other) {
        if (!(other instanceof BooleanItemPreferenceArray)) {
            return false;
        }
        BooleanItemPreferenceArray otherArray = (BooleanItemPreferenceArray)other;
        return this.id == otherArray.id && Arrays.equals(this.ids, otherArray.ids);
    }

    @Override
    public Iterator<Preference> iterator() {
        return Iterators.transform(new CountingIterator(this.length()), new Function<Integer, Preference>(){

            @Override
            public Preference apply(Integer from) {
                return new PreferenceView(from);
            }
        });
    }

    public String toString() {
        StringBuilder result = new StringBuilder(10 * this.ids.length);
        result.append("BooleanItemPreferenceArray[itemID:");
        result.append(this.id);
        result.append(",{");
        for (int i = 0; i < this.ids.length; ++i) {
            if (i > 0) {
                result.append(',');
            }
            result.append(this.ids[i]);
        }
        result.append("}]");
        return result.toString();
    }

    private final class PreferenceView
    implements Preference {
        private final int i;

        private PreferenceView(int i) {
            this.i = i;
        }

        @Override
        public long getUserID() {
            return BooleanItemPreferenceArray.this.getUserID(this.i);
        }

        @Override
        public long getItemID() {
            return BooleanItemPreferenceArray.this.getItemID(this.i);
        }

        @Override
        public float getValue() {
            return 1.0f;
        }

        @Override
        public void setValue(float value) {
            throw new UnsupportedOperationException();
        }
    }
}

