/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.iterator.sequencefile;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.IOUtils;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterator;

public final class SequenceFileDirIterator<K extends Writable, V extends Writable>
extends ForwardingIterator<Pair<K, V>>
implements Closeable {
    private static final FileStatus[] NO_STATUSES = new FileStatus[0];
    private Iterator<Pair<K, V>> delegate;
    private final List<SequenceFileIterator<K, V>> iterators;

    public SequenceFileDirIterator(Path[] path, boolean reuseKeyValueInstances, Configuration conf) throws IOException {
        this.iterators = Lists.newArrayList();
        FileSystem fs = FileSystem.get((URI)path[0].toUri(), (Configuration)conf);
        FileStatus[] statuses = new FileStatus[path.length];
        for (int i = 0; i < statuses.length; ++i) {
            statuses[i] = fs.getFileStatus(path[i]);
        }
        this.init(statuses, reuseKeyValueInstances, conf);
    }

    public SequenceFileDirIterator(Path path, PathType pathType, PathFilter filter, Comparator<FileStatus> ordering, boolean reuseKeyValueInstances, Configuration conf) throws IOException {
        FileStatus[] statuses = HadoopUtil.getFileStatus(path, pathType, filter, ordering, conf);
        this.iterators = Lists.newArrayList();
        this.init(statuses, reuseKeyValueInstances, conf);
    }

    private void init(FileStatus[] statuses, final boolean reuseKeyValueInstances, final Configuration conf) {
        if (statuses == null) {
            statuses = NO_STATUSES;
        }
        UnmodifiableIterator<FileStatus> fileStatusIterator = Iterators.forArray(statuses);
        Iterator fsIterators = Iterators.transform(fileStatusIterator, new Function<FileStatus, Iterator<Pair<K, V>>>(){

            @Override
            public Iterator<Pair<K, V>> apply(FileStatus from) {
                try {
                    SequenceFileIterator iterator = new SequenceFileIterator(from.getPath(), reuseKeyValueInstances, conf);
                    SequenceFileDirIterator.this.iterators.add(iterator);
                    return iterator;
                }
                catch (IOException ioe) {
                    throw new IllegalStateException(from.getPath().toString(), ioe);
                }
            }
        });
        Collections.reverse(this.iterators);
        this.delegate = Iterators.concat(fsIterators);
    }

    @Override
    protected Iterator<Pair<K, V>> delegate() {
        return this.delegate;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.iterators);
        this.iterators.clear();
    }
}

