/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverage;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.recommender.AbstractRecommender;
import org.apache.mahout.cf.taste.impl.recommender.ByRescoreComparator;
import org.apache.mahout.cf.taste.impl.recommender.ClusterSimilarity;
import org.apache.mahout.cf.taste.impl.recommender.TopItems;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.recommender.ClusteringRecommender;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.common.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TreeClusteringRecommender2
extends AbstractRecommender
implements ClusteringRecommender {
    private static final Logger log = LoggerFactory.getLogger(TreeClusteringRecommender2.class);
    private static final int NUM_CLUSTER_RECS = 100;
    private final ClusterSimilarity clusterSimilarity;
    private final int numClusters;
    private final double clusteringThreshold;
    private final boolean clusteringByThreshold;
    private FastByIDMap<List<RecommendedItem>> topRecsByUserID;
    private FastIDSet[] allClusters;
    private FastByIDMap<FastIDSet> clustersByUserID;
    private final RefreshHelper refreshHelper;

    public TreeClusteringRecommender2(DataModel dataModel, ClusterSimilarity clusterSimilarity, int numClusters) throws TasteException {
        super(dataModel);
        Preconditions.checkArgument(numClusters >= 2, "numClusters must be at least 2");
        this.clusterSimilarity = Preconditions.checkNotNull(clusterSimilarity);
        this.numClusters = numClusters;
        this.clusteringThreshold = Double.NaN;
        this.clusteringByThreshold = false;
        this.refreshHelper = new RefreshHelper(new Callable<Object>(){

            @Override
            public Object call() throws TasteException {
                TreeClusteringRecommender2.this.buildClusters();
                return null;
            }
        });
        this.refreshHelper.addDependency(dataModel);
        this.refreshHelper.addDependency(clusterSimilarity);
        this.buildClusters();
    }

    public TreeClusteringRecommender2(DataModel dataModel, ClusterSimilarity clusterSimilarity, double clusteringThreshold) throws TasteException {
        super(dataModel);
        Preconditions.checkArgument(!Double.isNaN(clusteringThreshold), "clusteringThreshold must not be NaN");
        this.clusterSimilarity = Preconditions.checkNotNull(clusterSimilarity);
        this.numClusters = Integer.MIN_VALUE;
        this.clusteringThreshold = clusteringThreshold;
        this.clusteringByThreshold = true;
        this.refreshHelper = new RefreshHelper(new Callable<Object>(){

            @Override
            public Object call() throws TasteException {
                TreeClusteringRecommender2.this.buildClusters();
                return null;
            }
        });
        this.refreshHelper.addDependency(dataModel);
        this.refreshHelper.addDependency(clusterSimilarity);
        this.buildClusters();
    }

    @Override
    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer) throws TasteException {
        Preconditions.checkArgument(howMany >= 1, "howMany must be at least 1");
        this.buildClusters();
        log.debug("Recommending items for user ID '{}'", (Object)userID);
        List<RecommendedItem> recommended = this.topRecsByUserID.get(userID);
        if (recommended == null) {
            return Collections.emptyList();
        }
        DataModel dataModel = this.getDataModel();
        ArrayList<RecommendedItem> rescored = Lists.newArrayListWithCapacity(recommended.size());
        for (RecommendedItem recommendedItem : recommended) {
            long itemID = recommendedItem.getItemID();
            if (rescorer != null && rescorer.isFiltered(itemID) || dataModel.getPreferenceValue(userID, itemID) != null || rescorer != null && Double.isNaN(rescorer.rescore(itemID, recommendedItem.getValue()))) continue;
            rescored.add(recommendedItem);
        }
        Collections.sort(rescored, new ByRescoreComparator(rescorer));
        return rescored;
    }

    @Override
    public float estimatePreference(long userID, long itemID) throws TasteException {
        Float actualPref = this.getDataModel().getPreferenceValue(userID, itemID);
        if (actualPref != null) {
            return actualPref.floatValue();
        }
        this.buildClusters();
        List<RecommendedItem> topRecsForUser = this.topRecsByUserID.get(userID);
        if (topRecsForUser != null) {
            for (RecommendedItem item : topRecsForUser) {
                if (itemID != item.getItemID()) continue;
                return item.getValue();
            }
        }
        return Float.NaN;
    }

    @Override
    public FastIDSet getCluster(long userID) throws TasteException {
        this.buildClusters();
        FastIDSet cluster = this.clustersByUserID.get(userID);
        return cluster == null ? new FastIDSet() : cluster;
    }

    @Override
    public FastIDSet[] getClusters() throws TasteException {
        this.buildClusters();
        return this.allClusters;
    }

    private void buildClusters() throws TasteException {
        DataModel model = this.getDataModel();
        int numUsers = model.getNumUsers();
        if (numUsers == 0) {
            this.topRecsByUserID = new FastByIDMap();
            this.clustersByUserID = new FastByIDMap();
        } else {
            ArrayList<FastIDSet> clusters = Lists.newArrayList();
            LongPrimitiveIterator it = model.getUserIDs();
            while (it.hasNext()) {
                FastIDSet newCluster = new FastIDSet();
                newCluster.add(it.nextLong());
                clusters.add(newCluster);
            }
            boolean done = false;
            while (!done) {
                done = this.mergeClosestClusters(numUsers, clusters, done);
            }
            this.topRecsByUserID = this.computeTopRecsPerUserID(clusters);
            this.clustersByUserID = TreeClusteringRecommender2.computeClustersPerUserID(clusters);
            this.allClusters = clusters.toArray(new FastIDSet[clusters.size()]);
        }
    }

    private boolean mergeClosestClusters(int numUsers, List<FastIDSet> clusters, boolean done) throws TasteException {
        List<ClusterClusterPair> queue = this.findClosestClusters(numUsers, clusters);
        while (!queue.isEmpty()) {
            if (!this.clusteringByThreshold && clusters.size() <= this.numClusters) {
                done = true;
                break;
            }
            ClusterClusterPair top = queue.remove(0);
            if (this.clusteringByThreshold && top.getSimilarity() < this.clusteringThreshold) {
                done = true;
                break;
            }
            FastIDSet cluster1 = top.getCluster1();
            FastIDSet cluster2 = top.getCluster2();
            Iterator<FastIDSet> clusterIterator = clusters.iterator();
            boolean removed1 = false;
            boolean removed2 = false;
            while (!(!clusterIterator.hasNext() || removed1 && removed2)) {
                FastIDSet current = clusterIterator.next();
                if (!removed1 && cluster1 == current) {
                    clusterIterator.remove();
                    removed1 = true;
                    continue;
                }
                if (removed2 || cluster2 != current) continue;
                clusterIterator.remove();
                removed2 = true;
            }
            Iterator<ClusterClusterPair> queueIterator = queue.iterator();
            while (queueIterator.hasNext()) {
                ClusterClusterPair pair = queueIterator.next();
                FastIDSet pair1 = pair.getCluster1();
                FastIDSet pair2 = pair.getCluster2();
                if (pair1 != cluster1 && pair1 != cluster2 && pair2 != cluster1 && pair2 != cluster2) continue;
                queueIterator.remove();
            }
            FastIDSet merged = new FastIDSet(cluster1.size() + cluster2.size());
            merged.addAll(cluster1);
            merged.addAll(cluster2);
            for (FastIDSet cluster : clusters) {
                double similarity = this.clusterSimilarity.getSimilarity(merged, cluster);
                if (!(similarity > queue.get(queue.size() - 1).getSimilarity())) continue;
                ListIterator<ClusterClusterPair> queueIterator2 = queue.listIterator();
                while (queueIterator2.hasNext()) {
                    if (!(similarity > queueIterator2.next().getSimilarity())) continue;
                    queueIterator2.previous();
                    break;
                }
                queueIterator2.add(new ClusterClusterPair(merged, cluster, similarity));
            }
            clusters.add(merged);
        }
        return done;
    }

    private List<ClusterClusterPair> findClosestClusters(int numUsers, List<FastIDSet> clusters) throws TasteException {
        PriorityQueue queue = new PriorityQueue(numUsers + 1, Collections.reverseOrder());
        int size = clusters.size();
        for (int i = 0; i < size; ++i) {
            FastIDSet cluster1 = clusters.get(i);
            for (int j = i + 1; j < size; ++j) {
                FastIDSet cluster2 = clusters.get(j);
                double similarity = this.clusterSimilarity.getSimilarity(cluster1, cluster2);
                if (Double.isNaN(similarity)) continue;
                if (queue.size() < numUsers) {
                    queue.add(new ClusterClusterPair(cluster1, cluster2, similarity));
                    continue;
                }
                if (!(similarity > ((ClusterClusterPair)queue.poll()).getSimilarity())) continue;
                queue.add(new ClusterClusterPair(cluster1, cluster2, similarity));
                queue.poll();
            }
        }
        ArrayList<ClusterClusterPair> result = Lists.newArrayList(queue);
        Collections.sort(result);
        return result;
    }

    private FastByIDMap<List<RecommendedItem>> computeTopRecsPerUserID(Iterable<FastIDSet> clusters) throws TasteException {
        FastByIDMap<List<RecommendedItem>> recsPerUser = new FastByIDMap<List<RecommendedItem>>();
        for (FastIDSet cluster : clusters) {
            List<RecommendedItem> recs = this.computeTopRecsForCluster(cluster);
            LongPrimitiveIterator it = cluster.iterator();
            while (it.hasNext()) {
                recsPerUser.put(it.nextLong(), recs);
            }
        }
        return recsPerUser;
    }

    private List<RecommendedItem> computeTopRecsForCluster(FastIDSet cluster) throws TasteException {
        DataModel dataModel = this.getDataModel();
        FastIDSet possibleItemIDs = new FastIDSet();
        LongPrimitiveIterator it = cluster.iterator();
        while (it.hasNext()) {
            possibleItemIDs.addAll(dataModel.getItemIDsFromUser(it.nextLong()));
        }
        Estimator estimator = new Estimator(cluster);
        List<RecommendedItem> topItems = TopItems.getTopItems(100, possibleItemIDs.iterator(), null, estimator);
        log.debug("Recommendations are: {}", (Object)topItems);
        return Collections.unmodifiableList(topItems);
    }

    private static FastByIDMap<FastIDSet> computeClustersPerUserID(Collection<FastIDSet> clusters) {
        FastByIDMap<FastIDSet> clustersPerUser = new FastByIDMap<FastIDSet>(clusters.size());
        for (FastIDSet cluster : clusters) {
            LongPrimitiveIterator it = cluster.iterator();
            while (it.hasNext()) {
                clustersPerUser.put(it.nextLong(), cluster);
            }
        }
        return clustersPerUser;
    }

    @Override
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.refreshHelper.refresh(alreadyRefreshed);
    }

    public String toString() {
        return "TreeClusteringRecommender2[clusterSimilarity:" + this.clusterSimilarity + ']';
    }

    private final class Estimator
    implements TopItems.Estimator<Long> {
        private final FastIDSet cluster;

        private Estimator(FastIDSet cluster) {
            this.cluster = cluster;
        }

        @Override
        public double estimate(Long itemID) throws TasteException {
            DataModel dataModel = TreeClusteringRecommender2.this.getDataModel();
            FullRunningAverage average = new FullRunningAverage();
            LongPrimitiveIterator it = this.cluster.iterator();
            while (it.hasNext()) {
                Float pref = dataModel.getPreferenceValue(it.nextLong(), itemID);
                if (pref == null) continue;
                average.addDatum(pref.floatValue());
            }
            return average.getAverage();
        }
    }

    private static final class ClusterClusterPair
    implements Comparable<ClusterClusterPair> {
        private final FastIDSet cluster1;
        private final FastIDSet cluster2;
        private final double similarity;

        private ClusterClusterPair(FastIDSet cluster1, FastIDSet cluster2, double similarity) {
            this.cluster1 = cluster1;
            this.cluster2 = cluster2;
            this.similarity = similarity;
        }

        FastIDSet getCluster1() {
            return this.cluster1;
        }

        FastIDSet getCluster2() {
            return this.cluster2;
        }

        double getSimilarity() {
            return this.similarity;
        }

        public int hashCode() {
            return this.cluster1.hashCode() ^ this.cluster2.hashCode() ^ RandomUtils.hashDouble((double)this.similarity);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ClusterClusterPair)) {
                return false;
            }
            ClusterClusterPair other = (ClusterClusterPair)o;
            return this.cluster1.equals(other.getCluster1()) && this.cluster2.equals(other.getCluster2()) && this.similarity == other.getSimilarity();
        }

        @Override
        public int compareTo(ClusterClusterPair other) {
            double otherSimilarity = other.getSimilarity();
            if (this.similarity > otherSimilarity) {
                return -1;
            }
            if (this.similarity < otherSimilarity) {
                return 1;
            }
            return 0;
        }
    }
}

