/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import net.myrrix.common.NotReadyException;
import net.myrrix.common.parallel.Paralleler;
import net.myrrix.common.parallel.Processor;
import net.myrrix.online.RescorerProvider;
import net.myrrix.online.ServerRecommender;
import net.myrrix.web.AllConfig;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Rescorer;
import org.apache.mahout.common.LongPair;

public final class AllItemSimilarities
implements Callable<Object> {
    private final AllConfig config;

    public AllItemSimilarities(AllConfig config) {
        Preconditions.checkNotNull(config);
        this.config = config;
    }

    public static void main(String[] args) throws Exception {
        AllConfig config = AllConfig.build(args);
        if (config != null) {
            new AllItemSimilarities(config).call();
        }
    }

    @Override
    public Object call() throws IOException, InterruptedException, NotReadyException, ExecutionException {
        final ServerRecommender recommender = new ServerRecommender(this.config.getLocalInputDir());
        recommender.await();
        final RescorerProvider rescorerProvider = this.config.getRescorerProvider();
        final int howMany = this.config.getHowMany();
        File outFile = this.config.getOutFile();
        outFile.delete();
        final OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), Charsets.UTF_8);
        Processor<Long> processor = new Processor<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(Long itemID, long count) throws ExecutionException {
                List<RecommendedItem> similar;
                Rescorer<LongPair> rescorer = rescorerProvider == null ? null : rescorerProvider.getMostSimilarItemsRescorer(recommender, new String[0]);
                try {
                    similar = recommender.mostSimilarItems(new long[]{itemID}, howMany, rescorer);
                }
                catch (TasteException te) {
                    throw new ExecutionException(te);
                }
                String outLine = AllItemSimilarities.formatOutLine(itemID, similar);
                Writer writer = out;
                synchronized (writer) {
                    try {
                        out.write(outLine);
                    }
                    catch (IOException e) {
                        throw new ExecutionException(e);
                    }
                }
            }
        };
        Paralleler<Long> paralleler = new Paralleler<Long>(recommender.getAllItemIDs().iterator(), processor, "AllItemSimilarities");
        if (this.config.isParallel()) {
            paralleler.runInParallel();
        } else {
            paralleler.runInSerial();
        }
        ((Writer)out).close();
        return null;
    }

    static String formatOutLine(long id, Iterable<RecommendedItem> recs) {
        StringBuilder result = new StringBuilder(100);
        result.append(id);
        result.append("\t[");
        boolean first = true;
        for (RecommendedItem rec : recs) {
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            result.append(rec.getItemID()).append(':').append(rec.getValue());
        }
        result.append("]\n");
        return result.toString();
    }
}

